/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.finance;

import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocument;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.model.IBusExternalApiContextKeys;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.UploadExternalFinanceDocumentParameters;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.FinanceDocumentNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class UploadExternalFinanceDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection parametersCollection = (Collection)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        UploadExternalFinanceDocumentsProcessor.validate(parametersCollection);
        HashMap groupedDocuments = new HashMap();
        for (UploadExternalFinanceDocumentParameters uploadExternalFinanceDocumentParameters : parametersCollection) {
            EntityReference agentRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusExternalApiContextKeys.AUTHORIZED_USER);
            EntityContainer agentCtr = EntityStorage.get().resolve(agentRef);
            EntityReference supplierRef = ProfileHelper.getMainEmploymentRef((Person)((Person)agentCtr.getEntity()));
            ExternalFinanceDocument doc = new ExternalFinanceDocument();
            doc.setDate(DateUtils.toJavaDate((LocalDate)uploadExternalFinanceDocumentParameters.getDate()));
            doc.setCreated(new Date());
            doc.setNumber(uploadExternalFinanceDocumentParameters.getNumber());
            doc.setNumberPrefix(uploadExternalFinanceDocumentParameters.getNumberPrefix());
            doc.setNumberSuffix(uploadExternalFinanceDocumentParameters.getNumberSuffix());
            doc.setSupplier(supplierRef);
            doc.setCustomer(UploadExternalFinanceDocumentsProcessor.toEntityReference(uploadExternalFinanceDocumentParameters.getCustomerUid(), Organization.class, "ORGANIZATION_WITH_UID_NOT_FOUND"));
            doc.setPayer(UploadExternalFinanceDocumentsProcessor.toEntityReference(uploadExternalFinanceDocumentParameters.getPayerUid(), Organization.class, "ORGANIZATION_WITH_UID_NOT_FOUND"));
            doc.setContract(UploadExternalFinanceDocumentsProcessor.toEntityReference(uploadExternalFinanceDocumentParameters.getContractUid(), Contract.class, "CONTRACT_WITH_UID_NOT_FOUND"));
            doc.setCurrency((DictionaryReference)((CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, uploadExternalFinanceDocumentParameters.getCurrency())).toReference());
            doc.setAgent(agentRef);
            doc.setFinanceDocumentType(UploadExternalFinanceDocumentsProcessor.convert(uploadExternalFinanceDocumentParameters.getFinanceDocumentType()));
            doc.setName(uploadExternalFinanceDocumentParameters.getName());
            doc.setTotalAmount(uploadExternalFinanceDocumentParameters.getTotalAmount());
            doc.setContentType(uploadExternalFinanceDocumentParameters.getContentType());
            doc.setContent(uploadExternalFinanceDocumentParameters.getContent());
            doc.setCheckSum(MiscUtil.getCheckSum((byte[])uploadExternalFinanceDocumentParameters.getContent()));
            doc.setType(DocumentType.FINANCIAL_DOCUMENT);
            EntityReference<BookingFile> bookingRef = UploadExternalFinanceDocumentsProcessor.findBookingFile(uploadExternalFinanceDocumentParameters.getBookingFileNumber());
            doc.setOwner(bookingRef);
            doc.setExternal(true);
            doc.setExternalId(uploadExternalFinanceDocumentParameters.getExternalId());
            EntityContainer docCtr = EntityContainer.create((BaseEntity)doc);
            docCtr.getVersionInfo().setDataSource("ext-api");
            EntityStorage.get().save(docCtr, true);
            groupedDocuments.putIfAbsent(bookingRef, new ArrayList());
            ((Collection)groupedDocuments.get(bookingRef)).add(docCtr.getEntity());
        }
        for (Map.Entry entry : groupedDocuments.entrySet()) {
            this.sendNotification((EntityReference<BookingFile>)((EntityReference)entry.getKey()), (Collection)entry.getValue());
        }
    }

    private static void validate(Collection<UploadExternalFinanceDocumentParameters> parametersCollection) throws Exception {
        ArrayList<UploadExternalFinanceDocumentParameters> invalidParameters = new ArrayList<UploadExternalFinanceDocumentParameters>();
        for (UploadExternalFinanceDocumentParameters parameters : parametersCollection) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.name.name(), (Object)parameters.getName()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.checkSum.name(), (Object)MiscUtil.getCheckSum((byte[])parameters.getContent())));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), UploadExternalFinanceDocumentsProcessor.findBookingFile(parameters.getBookingFileNumber())));
            query.setLimit(1);
            if (EntityStorage.get().search(BasicDocumentIndex.class, query).getData().isEmpty()) continue;
            invalidParameters.add(parameters);
        }
        if (!invalidParameters.isEmpty()) {
            throw Xeption.forEndUser((String)"EXTERNAL_FINANCE_DOCUMENT_DUPLICATES_FOUND", (Object[])new Object[]{invalidParameters.stream().map(p -> String.format("%s (%s)", p.getName(), p.getBookingFileNumber())).collect(Collectors.joining(", "))});
        }
    }

    private static <E extends BaseEntity> EntityReference<E> toEntityReference(String uid, Class<E> cls, String notFoundMessage) {
        if (uid == null) {
            return null;
        }
        if (!EntityStorage.get().isAvailable(cls, uid)) {
            throw Xeption.forEndUser((String)notFoundMessage, (Object[])new Object[]{uid});
        }
        return EntityStorage.get().actualize(new EntityReference(uid, cls, null));
    }

    private static FinanceDocumentType convert(com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case CORRECTION_DOCUMENT: {
                return FinanceDocumentType.CORRECTION_DOCUMENT;
            }
            case ACCEPTANCE_CERTIFICATE: {
                return FinanceDocumentType.ACCEPTANCE_CERTIFICATE;
            }
            case INVOICE: {
                return FinanceDocumentType.INVOICE;
            }
            case INVOICE_CONSOLIDATED: {
                return FinanceDocumentType.INVOICE_CONSOLIDATED;
            }
            case INVOICE_FACTURA: {
                return FinanceDocumentType.INVOICE_FACTURA;
            }
            case INVOICE_PREPAYMENT: {
                return FinanceDocumentType.INVOICE_PREPAYMENT;
            }
            case UNIVERSAL_DOCUMENT: {
                return FinanceDocumentType.UNIVERSAL_DOCUMENT;
            }
            case STANDARD_BILL: {
                return FinanceDocumentType.STANDARD_BILL;
            }
        }
        throw Xeption.forDeveloper((String)"unsupported type {0}", (Object[])new Object[]{type.name()});
    }

    private static EntityReference<BookingFile> findBookingFile(String number) {
        if (number == null) {
            return null;
        }
        return EntityStorage.get().findReference(BookingFileIndex.class, BookingFileIndex.Property.fullNumber.name(), (Object)number);
    }

    private void sendNotification(EntityReference<BookingFile> bookingRef, Collection<BaseFileDocument> newDocuments) {
        EntityContainer bookingCtr = EntityStorage.get().resolve(bookingRef);
        if (bookingCtr == null) {
            return;
        }
        BookingFile booking = (BookingFile)bookingCtr.getEntity();
        if (booking.getReservations().isEmpty()) {
            SysLogHelper.audit(bookingRef, (String)"ext-fin-doc-notification", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)"NotificationFailed_NoReservationInBooking"), (Object[])new Object[0])});
            return;
        }
        Reservation reservation = (Reservation)booking.getReservations().get(0);
        if (reservation.getProducts().isEmpty()) {
            SysLogHelper.audit(bookingRef, (String)"ext-fin-doc-notification", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)"NotificationFailed_NoProductInReservation"), (Object[])new Object[0])});
            return;
        }
        try {
            NotificationsActionSet notificationActionSet = IbecorpRulesHelper.getNotificationActionSet(reservation);
            MailTemplate template = notificationActionSet.getExternalFinanceDocsNotificationTemplate();
            NotificationParameters notificationParameters = new NotificationParameters(reservation, bookingRef);
            NotificationHelper.sendNotification(() -> new FinanceDocumentNotification(notificationParameters, template, booking, newDocuments), bookingRef, true);
        }
        catch (Throwable ex) {
            SysLogHelper.audit(bookingRef, (String)"ext-fin-doc-notification", (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)"send notification failed", (String)TextUtil.getExceptionStackTrace((Throwable)ex), (Object[])new Object[0])});
        }
    }
}

