/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.gdsAccount;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2GdsAccountType;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.gdsAccount.ExtApiV2HotelGdsAccountHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseGdsAccount;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Reservation;
import java.util.Objects;
import java.util.Optional;

public interface ExtApiV2GdsAccountHandler<T extends ExtApiV2BaseGdsAccount> {
    public EntityReference<BaseGdsAccount> fromRest(ExtApiV2Reservation var1);

    public T toRest(BaseGdsAccount var1);

    public Class<T> getAccountClass();

    public static <T extends ExtApiV2BaseGdsAccount> ExtApiV2GdsAccountHandler<T> getHandlerByType(ExtApiV2GdsAccountType accountType) {
        if (accountType == ExtApiV2GdsAccountType.HOTEL) {
            return new ExtApiV2HotelGdsAccountHandler();
        }
        return null;
    }

    public static <T extends ExtApiV2BaseGdsAccount> ExtApiV2GdsAccountHandler<T> getHandlerByType(ExtApiV2ProductType productType) {
        if (productType == ExtApiV2ProductType.HOTEL) {
            return new ExtApiV2HotelGdsAccountHandler();
        }
        return null;
    }

    public static <T extends ExtApiV2BaseGdsAccount> ExtApiV2GdsAccountHandler<T> of(ExtApiV2Reservation reservation) {
        ExtApiV2BaseGdsAccount restGdsAccount = reservation.getGdsAccount();
        if (restGdsAccount == null) {
            return null;
        }
        ExtApiV2GdsAccountType accountType = restGdsAccount.getType();
        return Objects.requireNonNull(ExtApiV2GdsAccountHandler.getHandlerByType(accountType), String.format("Gds account handler of type %s not supported", accountType));
    }

    public static <T extends ExtApiV2BaseGdsAccount> ExtApiV2GdsAccountHandler<T> of(Reservation reservation) {
        EntityReference gdsAccount = reservation.getGdsNameInfo().getOnlineGdsAccount();
        if (gdsAccount == null) {
            return null;
        }
        Optional baseProduct = reservation.getProducts().stream().findFirst();
        if (baseProduct.isPresent()) {
            BaseProduct product = (BaseProduct)baseProduct.get();
            ExtApiV2ProductType restProductType = ExtApiV2ProductHandler.of(product).getRestProductType();
            return ExtApiV2GdsAccountHandler.getHandlerByType(restProductType);
        }
        return null;
    }
}

