/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.gdsAccount;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2GdsAccountType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.gdsAccount.ExtApiV2GdsAccountHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2HotelGdsAccount;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2HotelProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Reservation;
import java.util.List;

public class ExtApiV2HotelGdsAccountHandler
implements ExtApiV2GdsAccountHandler<ExtApiV2HotelGdsAccount> {
    @Override
    public EntityReference<BaseGdsAccount> fromRest(ExtApiV2Reservation restReservation) {
        HotelProvider hotelProvider = ((ExtApiV2HotelProduct)restReservation.getProducts().get(0)).getProvider();
        ExtApiV2HotelGdsAccount gdsAccountName = (ExtApiV2HotelGdsAccount)restReservation.getGdsAccount();
        if (hotelProvider != null && gdsAccountName != null) {
            List gdsAccountIndices;
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.hotelProvider.name(), (Object)hotelProvider));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.name.name(), (Object)gdsAccountName.getName()));
            SearchResult searchResult = LogicalStorage.get().getEntityStorage().search(GdsAccountIndex.class, query);
            if (searchResult != null && (gdsAccountIndices = searchResult.getData()).size() == 1) {
                return ((GdsAccountIndex)gdsAccountIndices.get(0)).getSource();
            }
        }
        return null;
    }

    @Override
    public ExtApiV2HotelGdsAccount toRest(BaseGdsAccount gdsAccount) {
        ExtApiV2HotelGdsAccount hotelGdsAccount = new ExtApiV2HotelGdsAccount();
        hotelGdsAccount.setName(gdsAccount.getName());
        hotelGdsAccount.setType(ExtApiV2GdsAccountType.HOTEL);
        return hotelGdsAccount;
    }

    @Override
    public Class<ExtApiV2HotelGdsAccount> getAccountClass() {
        return ExtApiV2HotelGdsAccount.class;
    }
}

