/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.aeroexpress.ExtApiV2AeroexpressConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2BaseProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2AeroexpressProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;

public class ExtApiV2AeroexpressProductHandler
extends ExtApiV2BaseProductHandler<AeroexpressTicket, ExtApiV2AeroexpressProduct> {
    @Override
    public ExtApiV2AeroexpressProduct toRest(AeroexpressTicket product) {
        ExtApiV2AeroexpressProduct toRest = (ExtApiV2AeroexpressProduct)super.toRest(product);
        toRest.setTicketNumber(product.getSystemNumber());
        toRest.setTicketType(product.getTicketType());
        toRest.setReservationId(product.getReservationId());
        toRest.setIssueDate(DateUtils.toLocalDateTime((Date)product.getIssueDate()));
        toRest.setIssueAgent(product.getAgent());
        toRest.setIssueAgentReference(ExtApiV2BookingHelper.convertAgentToGdsReference((EntityReference<Person>)product.getAgent(), product.getIssueDate()));
        if (product.getTraveller() != null) {
            toRest.setPassengerUid(product.getTraveller().getUid());
        }
        toRest.setClassOfService(product.getClassOfService());
        toRest.setSeat(product.getSeat());
        toRest.setDepartureLocation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getDepartureLocation()));
        toRest.setArrivalLocation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getArrivalLocation()));
        toRest.setDepartureDate(DateUtils.toLocalDateTime((Date)product.getDepartureDate()));
        if (product.getRelatedProduct() != null) {
            toRest.setRelatedProductUid(product.getRelatedProduct().getUid());
        }
        toRest.setEquivalentFare(product.getEquivalentFare());
        return toRest;
    }

    @Override
    public AeroexpressTicket fromRest(ExtApiV2AeroexpressProduct restProduct, String bookingCtrUid) {
        AeroexpressTicket fromRest = (AeroexpressTicket)super.fromRest(restProduct, bookingCtrUid);
        fromRest.setSystemNumber(restProduct.getTicketNumber());
        fromRest.setTicketType(restProduct.getTicketType());
        fromRest.setReservationId(restProduct.getReservationId());
        fromRest.setIssueDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getIssueDate()));
        if (restProduct.getIssueAgent() != null) {
            fromRest.setAgent(restProduct.getIssueAgent());
        } else {
            fromRest.setAgent(ExtApiV2BookingHelper.findAgent(restProduct.getIssueAgentReference(), restProduct.getIssueDate()));
        }
        fromRest.setClassOfService(restProduct.getClassOfService());
        fromRest.setSeat(restProduct.getSeat());
        fromRest.setDepartureLocation((DictionaryReference)ExtApiV2AeroexpressConverterHelper.findGeoLocation(restProduct.getDepartureLocation()));
        fromRest.setArrivalLocation((DictionaryReference)ExtApiV2AeroexpressConverterHelper.findGeoLocation(restProduct.getArrivalLocation()));
        fromRest.setDepartureDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getDepartureDate()));
        fromRest.setRelatedProduct(ExtApiV2AeroexpressConverterHelper.getRelatedProduct(restProduct.getRelatedProductUid(), bookingCtrUid));
        fromRest.setEquivalentFare(restProduct.getEquivalentFare());
        ExtApiV2ConverterHelper.updateClientFops((ExtApiV2BaseProduct)restProduct, (BaseProduct)fromRest);
        return fromRest;
    }

    @Override
    AeroexpressTicket getProduct(ExtApiV2AeroexpressProduct restProduct, String bookingCtrUid) {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingCtrUid);
        if (bookingCtr != null) {
            return (AeroexpressTicket)((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(product -> MiscUtil.equals((Object)restProduct.getUid(), (Object)product.getUid())).findFirst().orElseGet(AeroexpressTicket::new);
        }
        return new AeroexpressTicket();
    }

    @Override
    ExtApiV2AeroexpressProduct getRestProduct() {
        return new ExtApiV2AeroexpressProduct();
    }

    @Override
    public ExtApiV2ProductType getRestProductType() {
        return ExtApiV2ProductType.AEROEXPRESS;
    }

    @Override
    public Class<ExtApiV2AeroexpressProduct> getRestProductClass() {
        return ExtApiV2AeroexpressProduct.class;
    }

    @Override
    public Class<AeroexpressTicket> getProductClass() {
        return AeroexpressTicket.class;
    }

    @Override
    public void linkTravellersWithProduct(AeroexpressTicket product, ExtApiV2AeroexpressProduct restProduct, Map<String, Traveller> travellerMap) {
        if (TextUtil.isBlank((String)restProduct.getPassengerUid())) {
            return;
        }
        Traveller traveller = travellerMap.computeIfAbsent(restProduct.getPassengerUid(), uid -> ExtApiV2ConverterHelper.getTravellerByPassengerUid(uid, travellerMap));
        ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, traveller);
    }

    @Override
    public String getRestSystemNumber(ExtApiV2AeroexpressProduct restProduct) {
        return restProduct.getTicketNumber();
    }

    @Override
    public ProductStatus getRestProductStatus(ExtApiV2AeroexpressProduct restProduct) {
        return restProduct.getProductStatus();
    }

    @Override
    public LocalDateTime getRestIssueDate(ExtApiV2AeroexpressProduct restProduct) {
        return restProduct.getIssueDate();
    }
}

