/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2BaseProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2AviaProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;

public class ExtApiV2AviaProductHandler
extends ExtApiV2BaseProductHandler<Product, ExtApiV2AviaProduct> {
    @Override
    public ExtApiV2AviaProduct toRest(Product product) {
        ExtApiV2AviaProduct toRest = (ExtApiV2AviaProduct)super.toRest(product);
        toRest.setTicketNumber(product.getSystemNumber());
        toRest.setPcc(product.getPcc());
        toRest.setTourCode(product.getTourCode());
        toRest.setContractCode(product.getTripartiteContractDetails().getContractCode());
        toRest.setValidatorCode(product.getValidatorCode());
        toRest.setEndorsement(product.getEndorsement());
        toRest.setTicketType(product.getTicketType());
        toRest.setTariffType(product.getTariffType());
        toRest.setMcoCategory(product.getMcoCategory());
        toRest.setProductCategory(product.getProductCategory());
        toRest.setHasVat(AirProductHelper.calculateTaxesVatAmount((Product)product) != null || AirProductHelper.calculateTariffEquivalentVat((Product)product) != null);
        toRest.setCarrier(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getCarrier()));
        toRest.setPassengerType(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getPassengerType()));
        toRest.setProductPrice(ExtApiV2AviaConverterHelper.convertProductPrice2Rest(product));
        toRest.setIssueAgent(product.getCashier());
        toRest.setIssueAgentReference(ExtApiV2BookingHelper.convertAgentToGdsReference((EntityReference<Person>)product.getCashier(), product.getIssueDate()));
        toRest.getSegmentTariffs().addAll(ExtApiV2AviaConverterHelper.convertSegmentLegs2Rest(product.getSegmentTariffs()));
        toRest.setTransportationType(AirProductHelper.getTransportationType((Product)product));
        if (product.getBlankType() != null) {
            toRest.setBlank(product.getBlankType());
        }
        if (product.getTraveller() != null) {
            toRest.setPassengerUid(product.getTraveller().getUid());
        }
        toRest.setSalesOriginProvider(product.getSalesOriginProvider());
        toRest.setSalesOriginContent(product.getSalesOriginContent());
        return toRest;
    }

    @Override
    public Product fromRest(ExtApiV2AviaProduct restProduct, String bookingCtrUid) {
        Product fromRest = (Product)super.fromRest(restProduct, bookingCtrUid);
        fromRest.setSystemNumber(restProduct.getTicketNumber());
        fromRest.setPcc(restProduct.getPcc());
        fromRest.setTourCode(restProduct.getTourCode());
        fromRest.getTripartiteContractDetails().setContractCode(restProduct.getContractCode());
        fromRest.setValidatorCode(restProduct.getValidatorCode());
        fromRest.setEndorsement(restProduct.getEndorsement());
        fromRest.setTicketType(restProduct.getTicketType());
        fromRest.setTariffType(restProduct.getTariffType());
        fromRest.setMcoCategory(restProduct.getMcoCategory());
        fromRest.setProductCategory(Optional.ofNullable(restProduct.getProductCategory()).orElse(ProductCategory.AIR));
        if (restProduct.getIssueAgent() != null) {
            fromRest.setCashier(restProduct.getIssueAgent());
        } else {
            fromRest.setCashier(ExtApiV2BookingHelper.findAgent(restProduct.getIssueAgentReference(), restProduct.getIssueDate()));
        }
        Collection blankTypes = DictHelper.getBlankTypes((EntityReference)fromRest.getBlankOwnerRef(), null, (ProductCategory)fromRest.getProductCategory(), (BlankCategory)BlankCategory.ETICKET);
        if (blankTypes.size() == 1) {
            fromRest.setBlankType((DictionaryReference)blankTypes.iterator().next());
        }
        fromRest.setPassengerType(ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(PassengerType.class, (ExtApiV2DictionaryWrapper)restProduct.getPassengerType()));
        ExtApiV2AviaConverterHelper.convertRestProductPrice(restProduct.getProductPrice(), fromRest);
        ExtApiV2AviaConverterHelper.convertRestProductSegmentLegs(fromRest.getSegmentTariffs(), restProduct.getSegmentTariffs());
        DictionaryReference carrierRef = ExtApiV2DictionaryConverterHelper.getAirlineFromDictionaryWrapper((ExtApiV2DictionaryWrapper)restProduct.getCarrier(), (Date)DateUtils.toJavaDate((LocalDateTime)restProduct.getIssueDate()));
        fromRest.setCarrier(carrierRef);
        fromRest.setCarrierNumber((String)Optional.ofNullable(DictionaryCache.get().resolveReference(carrierRef)).map(Airline::getAirlineNumber).orElse(null));
        fromRest.setSalesOriginProvider(restProduct.getSalesOriginProvider());
        fromRest.setSalesOriginContent(restProduct.getSalesOriginContent());
        restProduct.getClientFops().forEach(restFop -> AirProductHelper.getClientContractRelation((Product)fromRest).getFops().stream().filter(productFop -> MiscUtil.equals((Object)restFop.getUid(), (Object)productFop.getUid(), (boolean)false)).forEach(productFop -> {
            productFop.setType(restFop.getPaymentType());
            productFop.setOperationDate(DateUtils.toJavaDate((LocalDateTime)restFop.getOperationDate()));
            productFop.setAgent(restFop.getAgent());
        }));
        return fromRest;
    }

    @Override
    public ExtApiV2ProductType getRestProductType() {
        return ExtApiV2ProductType.AVIA;
    }

    @Override
    public Class<ExtApiV2AviaProduct> getRestProductClass() {
        return ExtApiV2AviaProduct.class;
    }

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public void linkTravellersWithProduct(Product product, ExtApiV2AviaProduct restProduct, Map<String, Traveller> travellerMap) {
        if (TextUtil.isBlank((String)restProduct.getPassengerUid())) {
            return;
        }
        Traveller traveller = restProduct.isMatchByProfile() ? ExtApiV2ConverterHelper.getTravellerByPassengerUid(restProduct.getPassengerUid(), travellerMap) : travellerMap.get(restProduct.getPassengerUid());
        if (traveller == null) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getTravellerNotFound((String)restProduct.getPassengerUid()).getText(), (Object[])new Object[0]);
        }
        product.setTraveller(traveller);
        ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, traveller);
    }

    @Override
    Product getProduct(ExtApiV2AviaProduct restProduct, String bookingCtrUid) {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingCtrUid);
        if (bookingCtr != null) {
            return (Product)((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(product -> MiscUtil.equals((Object)restProduct.getUid(), (Object)product.getUid())).findFirst().orElse((BaseProduct)new Product());
        }
        return new Product();
    }

    @Override
    ExtApiV2AviaProduct getRestProduct() {
        return new ExtApiV2AviaProduct();
    }

    @Override
    public String getRestSystemNumber(ExtApiV2AviaProduct restProduct) {
        return restProduct.getTicketNumber();
    }

    @Override
    public ProductStatus getRestProductStatus(ExtApiV2AviaProduct restProduct) {
        return restProduct.getProductStatus();
    }

    @Override
    public LocalDateTime getRestIssueDate(ExtApiV2AviaProduct restProduct) {
        return restProduct.getIssueDate();
    }
}

