/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Organization;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class ExtApiV2BaseProductHandler<P extends BaseProduct, R extends ExtApiV2BaseProduct>
implements ExtApiV2ProductHandler<P, R> {
    @Override
    public R toRest(P product) {
        BaseProduct previousProduct;
        BaseProduct nextProduct;
        Object restProduct = this.getRestProduct();
        ProductHandler productHandler = ProductHandler.of(product);
        restProduct.setUid(product.getUid());
        restProduct.setIssueDate(DateUtils.toLocalDateTime((Date)GeneralProductHelper.getProductDate(product)));
        restProduct.setAgency(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)GeneralProductHelper.getAgency(product)));
        restProduct.setSubagency(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)GeneralProductHelper.getSubagency(product)));
        restProduct.setSupplier(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)GeneralProductHelper.getSupplier(product)));
        restProduct.setProductType(this.getRestProductType());
        restProduct.setProductStatus(productHandler.getStatus(product));
        restProduct.setSalesPointCode(ExtApiV2BookingHelper.getSalesPointCode((EntityReference<SalesPoint>)GeneralProductHelper.getSalesPoint(product)));
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(GeneralProductHelper.getBlankOwner(product));
        Optional.ofNullable(blankOwnerCtr).ifPresent(blankOwner -> {
            restProduct.setBlankOwner(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)blankOwner.toReference()));
            restProduct.setBlankOwnerCode(((Organization)blankOwner.getEntity()).getCode());
        });
        restProduct.setShipmentsDateClient(DateUtils.toLocalDateTime((Date)product.getShipmentsDate()));
        restProduct.setShipmentsDateSubagent(DateUtils.toLocalDateTime((Date)product.getShipmentsDateSubagent()));
        product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getShipment).map(shipmentRef -> EntityStorage.get().resolve(shipmentRef)).filter(Objects::nonNull).map(shipmentCtr -> ((Shipment)shipmentCtr.getEntity()).getNumber()).distinct().forEach(shipmentNumber -> restProduct.getShipmentNumbers().add(shipmentNumber));
        restProduct.setVendorContractApplied(Optional.ofNullable(GeneralProductHelper.getVendorContractRelation(product)).map(contract -> contract.getGeneralData().getContractData().getContract() != null).orElse(false).booleanValue());
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation(product);
        if (clientContractRelation != null) {
            if (CollectionUtil.isNotEmpty((Collection)clientContractRelation.getFops())) {
                restProduct.setAccountingAgent(((GeneralProductFop)clientContractRelation.getFops().get(0)).getAgent());
            }
            restProduct.setClientContractApplied(clientContractRelation.getGeneralData().getContractData().getContract() != null);
            String currency = Optional.ofNullable(clientContractRelation.getGeneralData().getCurrency()).map(DictionaryReference::getCode).orElse(null);
            restProduct.getClientFops().addAll(clientContractRelation.getFops().stream().map(productFop -> ExtApiV2CommonConverterHelper.convertProductFop2Rest((GeneralProductFop)productFop, (String)currency)).collect(Collectors.toList()));
        }
        if ((nextProduct = productHandler.getNextProduct(product)) != null) {
            restProduct.setNextProductUid(nextProduct.getUid());
        }
        if ((previousProduct = productHandler.getPreviousProduct(product)) != null) {
            restProduct.setPreviousProductUid(previousProduct.getUid());
        }
        return restProduct;
    }

    @Override
    public P fromRest(R restProduct, String bookingCtrUid) {
        if (TextUtil.isBlank((String)restProduct.getUid())) {
            restProduct.setUid(UUIDUtil.toString((UUID)UUID.randomUUID()));
        }
        P baseProduct = this.getProduct(restProduct, bookingCtrUid);
        ProductHandler handler = ProductHandler.of(baseProduct);
        handler.setIssueDate(baseProduct, DateUtils.toJavaDate((LocalDateTime)restProduct.getIssueDate()));
        handler.setAgency(baseProduct, ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)restProduct.getAgency()));
        handler.setSubagency(baseProduct, ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)restProduct.getSubagency()));
        handler.setSupplier(baseProduct, ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)restProduct.getSupplier()));
        handler.setSalesPoint(baseProduct, ExtApiV2BookingHelper.findSalesPoint(restProduct.getSalesPointCode()));
        handler.setBlankOwner(baseProduct, this.findBlankOwner(restProduct.getBlankOwnerCode()));
        handler.setStatus(baseProduct, restProduct.getProductStatus());
        return baseProduct;
    }

    abstract P getProduct(R var1, String var2);

    abstract R getRestProduct();

    private EntityReference<Organization> findBlankOwner(String code) {
        if (TextUtil.nonBlank((String)code)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER)}));
            SearchResult result = EntityStorage.get().search(OrganizationIndex.class, query);
            return result.getTotalCount() == 1 ? ((OrganizationIndex)result.getData().get(0)).getSource() : null;
        }
        return null;
    }
}

