/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2BaseProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.hotel.ExtApiV2HotelProductConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.hotel.ExtApiV2HotelRestConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2HotelProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2HotelProductHandler
extends ExtApiV2BaseProductHandler<HotelProduct, ExtApiV2HotelProduct> {
    @Override
    public ExtApiV2HotelProduct toRest(HotelProduct product) {
        ExtApiV2HotelProduct toRest = (ExtApiV2HotelProduct)super.toRest(product);
        toRest.setProductNumber(product.getSystemNumber());
        toRest.setPcc(product.getPcc());
        toRest.setHotelAggregatorPcc(product.getUsedPcc());
        toRest.setProvider(product.getProvider());
        toRest.setSubProviderName(HotelsHelper.getSubProviderNameFromCode((DictionaryReference)product.getSubProvider()));
        toRest.setProviderProfileId(product.getProviderProfileId());
        toRest.setBlankOwnerCode(product.getBlankOwnerCode());
        toRest.setHotelProductStatus(product.getHotelAggrStatus());
        toRest.setTariffType(product.getTariffType());
        toRest.setTicketType(product.getTicketType());
        toRest.setGdsCurrency(product.getGdsCurrency());
        toRest.setValidatorCode(product.getValidatorCode());
        toRest.setCancellable(product.isCancellable());
        if (!product.getRooms().isEmpty()) {
            Optional.ofNullable(product.getRooms().get(0)).map(Room::getEquivVatRate).ifPresent(arg_0 -> ((ExtApiV2HotelProduct)toRest).setTotalVatRate(arg_0));
        }
        Optional.ofNullable(HotelProductHelper.calculateTotalVatAmount((HotelProduct)product)).ifPresent(value -> {
            toRest.setTotalVatAmount(value);
            toRest.setHasVat(true);
        });
        toRest.setRoom(ExtApiV2HotelProductConverterHelper.convertHotelRoom2Rest(product.getRooms()));
        toRest.setIssueAgent(product.getCashier());
        toRest.setIssueAgentReference(ExtApiV2BookingHelper.convertAgentToGdsReference((EntityReference<Person>)product.getCashier(), product.getIssueDate()));
        toRest.setHotelData(ExtApiV2HotelProductConverterHelper.buildHotelData(product));
        toRest.setHotelCommission(ExtApiV2HotelProductConverterHelper.convertHotelCommission2Rest(product.getHotelAggrCommission()));
        toRest.setHotelCorporateData(ExtApiV2HotelProductConverterHelper.buildHotelCorporateData(product));
        toRest.setFreeCancellationDate(DateUtils.toLocalDateTime((Date)product.getFreeCancellationTerm()));
        toRest.setUnholdDate(DateUtils.toLocalDateTime((Date)product.getUnholdDate()));
        toRest.getVendorCommissions().addAll(ExtApiV2HotelProductConverterHelper.convertVendorCommissions2Rest(product));
        toRest.getCancellationCharges().addAll(product.getCancellationCharges().stream().map(ExtApiV2HotelProductConverterHelper::convertCancellationCharge2Rest).collect(Collectors.toList()));
        toRest.getAdditionalServices().addAll(product.getAdditionalServices().stream().map(ExtApiV2HotelProductConverterHelper::convertAdditionalService2Rest).collect(Collectors.toList()));
        toRest.getPenalties().addAll(product.getPenalties().stream().map(ExtApiV2HotelProductConverterHelper::convertPenalty2Rest).collect(Collectors.toList()));
        toRest.getTaxes().addAll(product.getTaxes().stream().map(ExtApiV2HotelProductConverterHelper::convertTax2Rest).collect(Collectors.toList()));
        toRest.getGuests().putAll(ExtApiV2HotelProductConverterHelper.convertProductTravellers2Rest(product));
        return toRest;
    }

    @Override
    public HotelProduct fromRest(ExtApiV2HotelProduct restProduct, String bookingCtrUid) {
        HotelProduct fromRest = (HotelProduct)super.fromRest(restProduct, bookingCtrUid);
        fromRest.setSystemNumber(restProduct.getProductNumber());
        fromRest.setPcc(restProduct.getPcc());
        fromRest.setUsedPcc(restProduct.getHotelAggregatorPcc());
        fromRest.setProvider(restProduct.getProvider());
        fromRest.setSubProvider(HotelsHelper.findSubProvider((HotelProvider)restProduct.getProvider(), (String)restProduct.getSubProviderName()));
        fromRest.setProviderProfileId(restProduct.getProviderProfileId());
        fromRest.setBlankOwnerCode(restProduct.getBlankOwnerCode());
        fromRest.setHotelAggrStatus(restProduct.getHotelProductStatus());
        fromRest.setTariffType(restProduct.getTariffType());
        fromRest.setTicketType(restProduct.getTicketType());
        fromRest.setGdsCurrency(restProduct.getGdsCurrency());
        fromRest.setValidatorCode(restProduct.getValidatorCode());
        fromRest.setCancellable(restProduct.isCancellable());
        if (restProduct.getIssueAgent() != null) {
            fromRest.setCashier(restProduct.getIssueAgent());
        } else {
            fromRest.setCashier(ExtApiV2BookingHelper.findAgent(restProduct.getIssueAgentReference(), restProduct.getIssueDate()));
        }
        fromRest.setHotelAggrCommission(ExtApiV2HotelRestConverterHelper.convertRestHotelCommission(restProduct.getHotelCommission()));
        fromRest.setFreeCancellationTerm(DateUtils.toJavaDate((LocalDateTime)restProduct.getFreeCancellationDate()));
        fromRest.setUnholdDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getUnholdDate()));
        fromRest.getCancellationCharges().clear();
        fromRest.getAdditionalServices().clear();
        fromRest.getPenalties().clear();
        fromRest.getTaxes().clear();
        fromRest.getCancellationCharges().addAll(restProduct.getCancellationCharges().stream().map(ExtApiV2HotelRestConverterHelper::convertRestCancellationCharge).collect(Collectors.toList()));
        fromRest.getAdditionalServices().addAll(restProduct.getAdditionalServices().stream().map(ExtApiV2HotelRestConverterHelper::convertRestAdditionalService).collect(Collectors.toList()));
        fromRest.getPenalties().addAll(restProduct.getPenalties().stream().map(ExtApiV2HotelRestConverterHelper::convertPenalty2Rest).collect(Collectors.toList()));
        fromRest.getTaxes().addAll(restProduct.getTaxes().stream().map(ExtApiV2HotelRestConverterHelper::convertTax2Rest).collect(Collectors.toList()));
        ExtApiV2HotelRestConverterHelper.convertRestRoom(restProduct.getRoom(), restProduct.getHotelData(), fromRest.getRooms());
        ExtApiV2HotelRestConverterHelper.convertRestHotelData(restProduct.getHotelData(), fromRest);
        ExtApiV2HotelRestConverterHelper.convertRestHotelCorporateData(restProduct.getHotelCorporateData(), fromRest);
        HotelsReservationHelper.updateVendorContractRelationCommission((HotelProduct)fromRest, (HotelProductCommission)fromRest.getHotelAggrCommission());
        restProduct.getClientFops().forEach(restFop -> HotelProductHelper.getClientContractRelation((HotelProduct)fromRest).getFops().stream().filter(productFop -> MiscUtil.equals((Object)restFop.getUid(), (Object)productFop.getUid(), (boolean)false)).forEach(productFop -> {
            productFop.setType(restFop.getPaymentType());
            productFop.setOperationDate(DateUtils.toJavaDate((LocalDateTime)restFop.getOperationDate()));
            productFop.setAgent(restFop.getAgent());
        }));
        return fromRest;
    }

    @Override
    HotelProduct getProduct(ExtApiV2HotelProduct restProduct, String bookingCtrUid) {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingCtrUid);
        if (bookingCtr != null) {
            return (HotelProduct)((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(product -> MiscUtil.equals((Object)restProduct.getUid(), (Object)product.getUid())).findFirst().orElse((BaseProduct)new HotelProduct());
        }
        return new HotelProduct();
    }

    @Override
    ExtApiV2HotelProduct getRestProduct() {
        return new ExtApiV2HotelProduct();
    }

    @Override
    public ExtApiV2ProductType getRestProductType() {
        return ExtApiV2ProductType.HOTEL;
    }

    @Override
    public Class<ExtApiV2HotelProduct> getRestProductClass() {
        return ExtApiV2HotelProduct.class;
    }

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }

    @Override
    public void linkTravellersWithProduct(HotelProduct product, ExtApiV2HotelProduct restProduct, Map<String, Traveller> travellerMap) {
        product.getTravellers().clear();
        product.getTravellersPassengerTypes().clear();
        restProduct.getGuests().forEach((uid, type) -> {
            Traveller traveller = type != null && type.isMatchByProfile() ? ExtApiV2ConverterHelper.getTravellerByPassengerUid(uid, travellerMap) : (Traveller)travellerMap.get(uid);
            if (traveller == null) {
                throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getTravellerNotFound((String)uid).getText(), (Object[])new Object[0]);
            }
            product.getTravellers().add(traveller);
            PassengerTypeReference reference = new PassengerTypeReference();
            DictionaryReference passengerType = ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(PassengerType.class, (ExtApiV2DictionaryWrapper)type);
            reference.setTravellerUid(traveller.getUid());
            reference.setPassengerType(passengerType);
            product.getTravellersPassengerTypes().add(reference);
        });
    }

    @Override
    public String getRestSystemNumber(ExtApiV2HotelProduct restProduct) {
        return restProduct.getProductNumber();
    }

    @Override
    public ProductStatus getRestProductStatus(ExtApiV2HotelProduct restProduct) {
        return restProduct.getProductStatus();
    }

    @Override
    public LocalDateTime getRestIssueDate(ExtApiV2HotelProduct restProduct) {
        return restProduct.getIssueDate();
    }
}

