/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandlersRegistry;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;

public interface ExtApiV2ProductHandler<P extends BaseProduct, R extends ExtApiV2BaseProduct> {
    public static <P extends BaseProduct, R extends ExtApiV2BaseProduct> ExtApiV2ProductHandler<P, R> of(P product) {
        return Objects.requireNonNull(ExtApiV2ProductHandlersRegistry.get().findProductHandler(product.getClass()), "Unexpected product type: " + product.getClass());
    }

    public static <P extends BaseProduct, R extends ExtApiV2BaseProduct> ExtApiV2ProductHandler<P, R> of(R restProduct) {
        return Objects.requireNonNull(ExtApiV2ProductHandlersRegistry.get().findProductHandler(restProduct.getProductType()), "Unexpected product type: " + restProduct.getClass());
    }

    public R toRest(P var1);

    public P fromRest(R var1, String var2);

    public ExtApiV2ProductType getRestProductType();

    public Class<R> getRestProductClass();

    public Class<P> getProductClass();

    public String getRestSystemNumber(R var1);

    public ProductStatus getRestProductStatus(R var1);

    public LocalDateTime getRestIssueDate(R var1);

    public void linkTravellersWithProduct(P var1, R var2, Map<String, Traveller> var3);
}

