/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtApiV2ProductHandlersRegistry {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ExtApiV2ProductHandler<? extends BaseProduct, ? extends ExtApiV2BaseProduct>> productHandlers = new HashMap<String, ExtApiV2ProductHandler<? extends BaseProduct, ? extends ExtApiV2BaseProduct>>();

    public static ExtApiV2ProductHandlersRegistry get() {
        return (ExtApiV2ProductHandlersRegistry)Environment.getPublished(ExtApiV2ProductHandlersRegistry.class);
    }

    public <P extends BaseProduct, R extends ExtApiV2BaseProduct> void register(ExtApiV2ProductHandler<P, R> handler) {
        if (this.productHandlers.containsKey(handler.getProductClass().getName())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getProductClass().getName()));
            return;
        }
        this.productHandlers.put(handler.getProductClass().getName(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public <P extends BaseProduct, R extends ExtApiV2BaseProduct> void unregister(ExtApiV2ProductHandler<P, R> handler) {
        this.productHandlers.remove(handler.getProductClass().getName());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public <P extends BaseProduct, R extends ExtApiV2BaseProduct> ExtApiV2ProductHandler<P, R> findProductHandler(Class<P> cls) {
        return this.productHandlers.get(cls.getName());
    }

    public <P extends BaseProduct, R extends ExtApiV2BaseProduct> ExtApiV2ProductHandler<P, R> findProductHandler(ExtApiV2ProductType productType) {
        if (productType != null) {
            for (ExtApiV2ProductHandler<? extends BaseProduct, ? extends ExtApiV2BaseProduct> handler : this.productHandlers.values()) {
                if (handler.getRestProductType() != productType) continue;
                return handler;
            }
        }
        return null;
    }
}

