/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandlersRegistry;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductInfo;
import java.util.Date;

public class ExtApiV2ProductHelper {
    public static ExtApiV2ProductInfo convertProductInfo2Rest(BaseProduct product) {
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        ExtApiV2ProductInfo productInfo = new ExtApiV2ProductInfo();
        productInfo.setNumber(String.join((CharSequence)", ", handler.getProductNumbers(product)));
        productInfo.setStatus(handler.getStatus(product));
        productInfo.setType(ExtApiV2ProductHandler.of(product).getRestProductType());
        productInfo.setShipmentsDateClient(DateUtils.toLocalDateTime((Date)product.getShipmentsDate()));
        productInfo.setShipmentsDateSubagent(DateUtils.toLocalDateTime((Date)product.getShipmentsDateSubagent()));
        return productInfo;
    }

    public static ExtApiV2ProductInfo convertProductInfo2Rest(CommonProductIndex productIndex) {
        ExtApiV2ProductInfo productInfo = new ExtApiV2ProductInfo();
        productInfo.setNumber(String.join((CharSequence)", ", productIndex.getSystemNumbers()));
        productInfo.setStatus(productIndex.getStatus());
        productInfo.setType(ExtApiV2ProductHelper.convertProductType2Rest(productIndex.getTravelSubject(), productIndex.getProductType()));
        productInfo.setShipmentsDateClient(DateUtils.toLocalDateTime((Date)productIndex.getShipmentsDate()));
        productInfo.setShipmentsDateSubagent(DateUtils.toLocalDateTime((Date)productIndex.getShipmentsDateSubagent()));
        return productInfo;
    }

    public static boolean isRestSupportedProduct(BaseProduct product) {
        return ExtApiV2ProductHandlersRegistry.get().findProductHandler(product.getClass()) != null;
    }

    public static boolean isRestSupportedProduct(CommonProductIndex productIndex) {
        return ExtApiV2ProductHelper.convertProductType2Rest(productIndex.getTravelSubject(), productIndex.getProductType()) != null;
    }

    public static ExtApiV2ProductType convertProductType2Rest(TravelSubject travelSubject, ProductType productType) {
        if (travelSubject != null) {
            switch (travelSubject) {
                case AIR: {
                    return ExtApiV2ProductType.AVIA;
                }
                case RAILWAY: {
                    return ExtApiV2ProductType.RAILWAY;
                }
                case HOTEL_RESERVATION: {
                    return ExtApiV2ProductType.HOTEL;
                }
                case TRANSFER: {
                    return ExtApiV2ProductType.TRANSFER;
                }
                case OTHER: {
                    return productType == ProductType.MISC_PRODUCT ? ExtApiV2ProductType.UNIVERSAL_PRODUCT : null;
                }
            }
        }
        return null;
    }
}

