/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2BaseProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2RailwayProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.rail.ExtApiV2RailConverterHelper;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;

public class ExtApiV2RailwayProductHandler
extends ExtApiV2BaseProductHandler<RailwayProduct, ExtApiV2RailwayProduct> {
    @Override
    public ExtApiV2RailwayProduct toRest(RailwayProduct product) {
        ExtApiV2RailwayProduct toRest = (ExtApiV2RailwayProduct)super.toRest(product);
        toRest.setTicketNumber(product.getSystemNumber());
        toRest.setCarrier(ExtApiV2ConverterHelper.convertPrincipal2RestReference((Principal)DictHelper.resolve((DictionaryReference)product.getCarrier())));
        toRest.setTicketType(product.getTicketType());
        toRest.setEndorsement(product.getEndorsement());
        toRest.setRefundExpireDate(DateUtils.toLocalDateTime((Date)product.getRefundExpireDate()));
        toRest.setIssueAgent(product.getCashier());
        toRest.setIssueAgentReference(ExtApiV2BookingHelper.convertAgentToGdsReference((EntityReference<Person>)product.getCashier(), product.getIssueDate()));
        toRest.setProductPrice(ExtApiV2RailConverterHelper.convertProductPrice2Rest(product));
        toRest.getRailwaySegments().addAll(ExtApiV2RailConverterHelper.convertRailSegments2Rest(product.getSegments()));
        toRest.getRailwayReservedSeats().addAll(ExtApiV2RailConverterHelper.convertReservedSeats2Rest(product.getReservedSeats()));
        toRest.getPassengers().putAll(ExtApiV2RailConverterHelper.convertProductTravellers2Rest(product));
        toRest.setTransportationType(RailwayProductHelper.getTransportationType((RailwayProduct)product));
        if (product.getBlankType() != null) {
            toRest.setBlank(product.getBlankType());
        }
        return toRest;
    }

    @Override
    public RailwayProduct fromRest(ExtApiV2RailwayProduct restProduct, String bookingCtrUid) {
        RailwayProduct fromRest = (RailwayProduct)super.fromRest(restProduct, bookingCtrUid);
        fromRest.setSystemNumber(restProduct.getTicketNumber());
        fromRest.setTicketType(restProduct.getTicketType());
        fromRest.setCarrier((DictionaryReference)ExtApiV2ConverterHelper.convertRestPrincipalReference(restProduct.getCarrier()));
        fromRest.setEndorsement(restProduct.getEndorsement());
        fromRest.setRefundExpireDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getRefundExpireDate()));
        if (restProduct.getIssueAgent() != null) {
            fromRest.setCashier(restProduct.getIssueAgent());
        } else {
            fromRest.setCashier(ExtApiV2BookingHelper.findAgent(restProduct.getIssueAgentReference(), restProduct.getIssueDate()));
        }
        fromRest.setBlankType(DictHelper.getBlankType((EntityReference)fromRest.getBlankOwnerRef(), null, null, (BlankCategory)BlankCategory.ETICKET));
        ExtApiV2RailConverterHelper.convertRestProductPrice(fromRest, restProduct.getProductPrice());
        ExtApiV2RailConverterHelper.convertRestRailwaySegments(restProduct.getRailwaySegments(), fromRest.getSegments());
        ExtApiV2RailConverterHelper.convertRestReservedSeat(restProduct.getRailwayReservedSeats(), fromRest.getReservedSeats(), fromRest.getSegments());
        restProduct.getClientFops().forEach(restFop -> RailwayProductHelper.getClientContractRelation((RailwayProduct)fromRest).getFops().stream().filter(productFop -> MiscUtil.equals((Object)restFop.getUid(), (Object)productFop.getUid(), (boolean)false)).forEach(productFop -> {
            productFop.setType(restFop.getPaymentType());
            productFop.setOperationDate(DateUtils.toJavaDate((LocalDateTime)restFop.getOperationDate()));
            productFop.setAgent(restFop.getAgent());
        }));
        return fromRest;
    }

    @Override
    public ExtApiV2ProductType getRestProductType() {
        return ExtApiV2ProductType.RAILWAY;
    }

    @Override
    public Class<ExtApiV2RailwayProduct> getRestProductClass() {
        return ExtApiV2RailwayProduct.class;
    }

    @Override
    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    @Override
    public void linkTravellersWithProduct(RailwayProduct product, ExtApiV2RailwayProduct restProduct, Map<String, Traveller> travellerMap) {
        product.getPassengers().clear();
        product.getPassengerTypes().clear();
        restProduct.getPassengers().forEach((uid, type) -> {
            Traveller traveller = type != null && type.isMatchByProfile() ? ExtApiV2ConverterHelper.getTravellerByPassengerUid(uid, travellerMap) : (Traveller)travellerMap.get(uid);
            if (traveller == null) {
                throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getTravellerNotFound((String)uid).getText(), (Object[])new Object[0]);
            }
            product.getPassengers().add(traveller);
            DictionaryReference passengerType = ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(PassengerType.class, (ExtApiV2DictionaryWrapper)type);
            RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)passengerType);
        });
    }

    @Override
    RailwayProduct getProduct(ExtApiV2RailwayProduct restProduct, String bookingCtrUid) {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingCtrUid);
        if (bookingCtr != null) {
            return (RailwayProduct)((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(product -> MiscUtil.equals((Object)restProduct.getUid(), (Object)product.getUid())).findFirst().orElse((BaseProduct)new RailwayProduct());
        }
        return new RailwayProduct();
    }

    @Override
    ExtApiV2RailwayProduct getRestProduct() {
        return new ExtApiV2RailwayProduct();
    }

    @Override
    public String getRestSystemNumber(ExtApiV2RailwayProduct restProduct) {
        return restProduct.getTicketNumber();
    }

    @Override
    public ProductStatus getRestProductStatus(ExtApiV2RailwayProduct restProduct) {
        return restProduct.getProductStatus();
    }

    @Override
    public LocalDateTime getRestIssueDate(ExtApiV2RailwayProduct restProduct) {
        return restProduct.getIssueDate();
    }
}

