/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Money;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2BaseProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2TransferProduct;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2TransferProductHandler
extends ExtApiV2BaseProductHandler<Transfer, ExtApiV2TransferProduct> {
    @Override
    public ExtApiV2TransferProduct toRest(Transfer product) {
        ExtApiV2TransferProduct toRest = (ExtApiV2TransferProduct)super.toRest(product);
        toRest.setProductNumber(product.getSystemNumber());
        toRest.setConfirmationNumber(product.getIwayBookerNumber());
        toRest.setTicketType(product.getTicketType());
        toRest.setIssueDate(DateUtils.toLocalDateTime((Date)product.getIssueDate()));
        toRest.setPassengersCount(product.getPassengersCount());
        toRest.setNotes(product.getNotes());
        toRest.setContactPerson(product.getContactPerson());
        toRest.getSubAddresses().addAll(product.getSubAddresses());
        toRest.setIssueAgent(product.getAgent());
        toRest.setIssueAgentReference(ExtApiV2BookingHelper.convertAgentToGdsReference((EntityReference<Person>)product.getAgent(), product.getIssueDate()));
        toRest.getPassengerUids().addAll(product.getTravellers().stream().map(BaseIdentity::getUid).collect(Collectors.toList()));
        toRest.setPenalty(product.getPenalty());
        toRest.setFare(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)product.getFare()));
        toRest.setEquivalentFare(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)product.getEquivalentFare()));
        Optional.ofNullable(product.getPenaltyVatValue()).ifPresent(vatValue -> {
            toRest.setPenaltyVatRate(vatValue.getRate());
            toRest.setPenaltyVatAmount(vatValue.getAmount());
        });
        Optional.ofNullable(product.getEquivalentFareVatValue()).ifPresent(vatValue -> {
            toRest.setEquivalentFareVatRate(vatValue.getRate());
            toRest.setEquivalentFareVatAmount(vatValue.getAmount());
        });
        Optional.ofNullable(product.getCarClass()).ifPresent(carClass -> toRest.setCarClassCode(carClass.getCode()));
        toRest.setStartDate(DateUtils.toLocalDateTime((Date)product.getStartDate()));
        toRest.setStartAddress(product.getStartAddress());
        toRest.setStartPlaceId(product.getStartPlaceId());
        toRest.setStartCountry(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getStartCountry()));
        toRest.setStartCity(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getStartCity()));
        toRest.setStartPlaceType(product.getStartType());
        toRest.setEndDate(DateUtils.toLocalDateTime((Date)product.getEndDate()));
        toRest.setEndAddress(product.getEndAddress());
        toRest.setEndPlaceId(product.getEndPlaceId());
        toRest.setEndCountry(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getEndCountry()));
        toRest.setEndCity(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getEndCity()));
        toRest.setEndPlaceType(product.getEndType());
        return toRest;
    }

    @Override
    public Transfer fromRest(ExtApiV2TransferProduct restProduct, String bookingCtrUid) {
        VatValue vatValue;
        Transfer fromRest = (Transfer)super.fromRest(restProduct, bookingCtrUid);
        fromRest.setSystemNumber(restProduct.getProductNumber());
        fromRest.setIwayBookerNumber(restProduct.getConfirmationNumber());
        fromRest.setTicketType(restProduct.getTicketType());
        fromRest.setIssueDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getIssueDate()));
        fromRest.setPassengersCount(restProduct.getPassengersCount());
        fromRest.setNotes(restProduct.getNotes());
        fromRest.setContactPerson(restProduct.getContactPerson());
        fromRest.getSubAddresses().addAll(restProduct.getSubAddresses());
        if (restProduct.getIssueAgent() != null) {
            fromRest.setAgent(restProduct.getIssueAgent());
        } else {
            fromRest.setAgent(ExtApiV2BookingHelper.findAgent(restProduct.getIssueAgentReference(), restProduct.getIssueDate()));
        }
        fromRest.setPenalty(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restProduct.getPenalty()));
        fromRest.setFare(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restProduct.getFare()));
        fromRest.setEquivalentFare(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restProduct.getEquivalentFare()));
        if (restProduct.getEquivalentFareVatAmount() != null) {
            vatValue = new VatValue();
            vatValue.setRate(restProduct.getEquivalentFareVatRate());
            vatValue.setAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restProduct.getEquivalentFareVatAmount()));
            fromRest.setEquivalentFareVatValue(vatValue);
        }
        if (restProduct.getPenaltyVatAmount() != null) {
            vatValue = new VatValue();
            vatValue.setRate(restProduct.getPenaltyVatRate());
            vatValue.setAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restProduct.getPenaltyVatAmount()));
            fromRest.setPenaltyVatValue(vatValue);
        }
        Optional.ofNullable(DictHelper.findCarsClassByCode((String)restProduct.getCarClassCode())).ifPresent(carClass -> fromRest.setCarClass((DictionaryReference)carClass.toReference()));
        fromRest.setStartDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getStartDate()));
        fromRest.setStartAddress(restProduct.getStartAddress());
        fromRest.setStartPlaceId(restProduct.getStartPlaceId());
        fromRest.setStartType(restProduct.getStartPlaceType());
        fromRest.setStartCountry(ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(Country.class, (ExtApiV2DictionaryWrapper)restProduct.getStartCountry()));
        fromRest.setStartCity(ExtApiV2DictionaryConverterHelper.getGeolocationFromDictionaryWrapper((ExtApiV2DictionaryWrapper)restProduct.getStartCity(), (LocationType)LocationType.CITY));
        fromRest.setEndDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getEndDate()));
        fromRest.setEndAddress(restProduct.getEndAddress());
        fromRest.setEndPlaceId(restProduct.getEndPlaceId());
        fromRest.setEndType(restProduct.getEndPlaceType());
        fromRest.setEndCountry(ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(Country.class, (ExtApiV2DictionaryWrapper)restProduct.getEndCountry()));
        fromRest.setEndCity(ExtApiV2DictionaryConverterHelper.getGeolocationFromDictionaryWrapper((ExtApiV2DictionaryWrapper)restProduct.getEndCity(), (LocationType)LocationType.CITY));
        ExtApiV2ConverterHelper.updateClientFops((ExtApiV2BaseProduct)restProduct, (BaseProduct)fromRest);
        return fromRest;
    }

    @Override
    Transfer getProduct(ExtApiV2TransferProduct restProduct, String bookingCtrUid) {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingCtrUid);
        if (bookingCtr != null) {
            return (Transfer)((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(product -> MiscUtil.equals((Object)restProduct.getUid(), (Object)product.getUid())).findFirst().orElse((BaseProduct)new Transfer());
        }
        return new Transfer();
    }

    @Override
    ExtApiV2TransferProduct getRestProduct() {
        return new ExtApiV2TransferProduct();
    }

    @Override
    public ExtApiV2ProductType getRestProductType() {
        return ExtApiV2ProductType.TRANSFER;
    }

    @Override
    public Class<ExtApiV2TransferProduct> getRestProductClass() {
        return ExtApiV2TransferProduct.class;
    }

    @Override
    public Class<Transfer> getProductClass() {
        return Transfer.class;
    }

    @Override
    public void linkTravellersWithProduct(Transfer product, ExtApiV2TransferProduct restProduct, Map<String, Traveller> travellerMap) {
        product.getTravellers().clear();
        if (restProduct.isMatchByProfile()) {
            for (String uid : restProduct.getPassengerUids()) {
                Traveller traveller = ExtApiV2ConverterHelper.getTravellerByPassengerUid(uid, travellerMap);
                product.getTravellers().add(traveller);
            }
        } else {
            for (String uid : restProduct.getPassengerUids()) {
                Traveller traveller = travellerMap.get(uid);
                if (traveller == null) {
                    throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getTravellerNotFound((String)uid).getText(), (Object[])new Object[0]);
                }
                product.getTravellers().add(traveller);
            }
        }
    }

    @Override
    public String getRestSystemNumber(ExtApiV2TransferProduct restProduct) {
        return restProduct.getProductNumber();
    }

    @Override
    public ProductStatus getRestProductStatus(ExtApiV2TransferProduct restProduct) {
        return restProduct.getProductStatus();
    }

    @Override
    public LocalDateTime getRestIssueDate(ExtApiV2TransferProduct restProduct) {
        return restProduct.getIssueDate();
    }
}

