/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameter;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Money;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Tax;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2BaseProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ManualFee;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2UniversalProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.universalProduct.ExtApiV2UniversalProductConverterHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2UniversalProductHandler
extends ExtApiV2BaseProductHandler<UniversalProduct, ExtApiV2UniversalProduct> {
    @Override
    public ExtApiV2UniversalProduct toRest(UniversalProduct product) {
        GeneralProductContractRelationData clientContractRelation;
        ExtApiV2UniversalProduct toRest = (ExtApiV2UniversalProduct)super.toRest(product);
        toRest.setProductNumber(product.getSystemNumber());
        toRest.setTicketType(product.getTicketType());
        toRest.setBlankType(product.getBlankType());
        toRest.setIssueDate(DateUtils.toLocalDateTime((Date)product.getIssueDate()));
        toRest.setIssueAgent(product.getAgent());
        toRest.setIssueAgentReference(ExtApiV2BookingHelper.convertAgentToGdsReference((EntityReference<Person>)product.getAgent(), product.getIssueDate()));
        toRest.setVat(product.isHasVat());
        toRest.setDontRecalcVat(product.isDontRecalcVat());
        toRest.setBaseFare(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)product.getBaseFare()));
        toRest.setEquivalentFare(product.getEquivalentFare());
        toRest.setTotalVat(product.getTotalVat());
        toRest.setDescription(product.getDescription());
        toRest.getTaxes().addAll(product.getTaxes().stream().map(tax -> {
            ExtApiV2Tax restTax = new ExtApiV2Tax();
            restTax.setCode(tax.getCode());
            restTax.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)tax.getAmount()));
            restTax.setEquivalentAmount(tax.getEquivalentAmount());
            return restTax;
        }).collect(Collectors.toList()));
        toRest.getTravellerUids().addAll(product.getTravellersUids());
        EntityContainer description = EntityStorage.get().resolve(product.getDescription());
        if (description != null) {
            toRest.getCustomParameters().addAll(product.getCustomParameters().stream().map(customParameter -> ExtApiV2UniversalProductConverterHelper.convertCustomParameterValue2Rest(customParameter, (EntityContainer<UniversalProductDescription>)description)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if ((clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product)) != null) {
            toRest.getClientManualFees().addAll(clientContractRelation.getCommissions().stream().map(commission -> {
                FeeProperties feeProperties;
                EntityContainer commissionPropertiesCtr = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (commissionPropertiesCtr != null && commissionPropertiesCtr.getEntity() instanceof FeeProperties && (feeProperties = (FeeProperties)commissionPropertiesCtr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED) {
                    ExtApiV2ManualFee extApiV2ManualFee = new ExtApiV2ManualFee();
                    extApiV2ManualFee.setUid(commission.getUid());
                    extApiV2ManualFee.setName(feeProperties.getDisplayName());
                    if (commission.getAmount() != null) {
                        extApiV2ManualFee.setAmount(commission.getAmount().getValue());
                        extApiV2ManualFee.setCurrency(commission.getAmount().getCurrency());
                    }
                    extApiV2ManualFee.setRate(commission.getRate());
                    return extApiV2ManualFee;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return toRest;
    }

    @Override
    public UniversalProduct fromRest(ExtApiV2UniversalProduct restProduct, String bookingCtrUid) {
        UniversalProduct fromRest = (UniversalProduct)super.fromRest(restProduct, bookingCtrUid);
        fromRest.setSystemNumber(restProduct.getProductNumber());
        fromRest.setTicketType(restProduct.getTicketType());
        fromRest.setBlankType(restProduct.getBlankType());
        fromRest.setIssueDate(DateUtils.toJavaDate((LocalDateTime)restProduct.getIssueDate()));
        if (restProduct.getIssueAgent() != null) {
            fromRest.setAgent(restProduct.getIssueAgent());
        } else {
            fromRest.setAgent(ExtApiV2BookingHelper.findAgent(restProduct.getIssueAgentReference(), restProduct.getIssueDate()));
        }
        fromRest.setHasVat(restProduct.hasVat());
        fromRest.setDontRecalcVat(restProduct.isDontRecalcVat());
        fromRest.setBaseFare(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restProduct.getBaseFare()));
        fromRest.setEquivalentFare(restProduct.getEquivalentFare());
        fromRest.setTotalVat(restProduct.getTotalVat());
        fromRest.setDescription(restProduct.getDescription());
        fromRest.getTaxes().clear();
        fromRest.getTaxes().addAll(restProduct.getTaxes().stream().map(restTax -> {
            GeneralProductTax tax = new GeneralProductTax();
            tax.setCode(restTax.getCode());
            tax.setAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restTax.getAmount()));
            tax.setEquivalentAmount(restTax.getEquivalentAmount());
            return tax;
        }).collect(Collectors.toList()));
        EntityContainer description = EntityStorage.get().resolve(restProduct.getDescription());
        if (description == null) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getDescriptionNotFound((String)restProduct.getDescription().getUid()).getText(), (Object[])new Object[0]);
        }
        fromRest.getCustomParameters().clear();
        try {
            ExtApiV2UniversalProductConverterHelper.convertRestCustomParameters(restProduct.getCustomParameters(), fromRest.getCustomParameters(), (EntityContainer<UniversalProductDescription>)description);
        }
        catch (ClassNotFoundException | ParseException e) {
            throw Xeption.forDeveloper((String)e.getMessage(), (Object[])new Object[0]);
        }
        for (UniversalProductCustomParameterDescription customParameterDescription : ((UniversalProductDescription)description.getEntity()).getCustomParameters()) {
            Optional<UniversalProductCustomParameter> requiredParameter;
            if (!customParameterDescription.isRequired() || (requiredParameter = fromRest.getCustomParameters().stream().filter(c -> c.getId().equals(customParameterDescription.getId())).findFirst()).isPresent()) continue;
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getMissingRequiredCustomParameter((String)customParameterDescription.getId()).getText(), (Object[])new Object[0]);
        }
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)fromRest);
        ExtApiV2ConverterHelper.updateClientFops((ExtApiV2BaseProduct)restProduct, clientContractRelation);
        for (ExtApiV2ManualFee extApiV2ManualFee : restProduct.getClientManualFees()) {
            clientContractRelation.getCommissions().stream().filter(commission -> {
                EntityContainer commissionPropertiesCtr = EntityStorage.get().resolve(commission.getCommissionProperties());
                return commissionPropertiesCtr != null && commissionPropertiesCtr.getEntity() instanceof FeeProperties && ((FeeProperties)commissionPropertiesCtr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED;
            }).filter(commission -> MiscUtil.equals((Object)commission.getUid(), (Object)extApiV2ManualFee.getUid(), (boolean)false)).forEach(commission -> {
                if (commission.getAmount() != null) {
                    commission.setAmount(MoneyHelper.buildMoney((BigDecimal)extApiV2ManualFee.getAmount(), (String)extApiV2ManualFee.getCurrency()));
                    commission.setEquivalentAmount(extApiV2ManualFee.getAmount());
                }
                commission.setRate(extApiV2ManualFee.getRate());
            });
        }
        return fromRest;
    }

    @Override
    UniversalProduct getProduct(ExtApiV2UniversalProduct restProduct, String bookingCtrUid) {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingCtrUid);
        if (bookingCtr != null) {
            return (UniversalProduct)((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(product -> MiscUtil.equals((Object)restProduct.getUid(), (Object)product.getUid())).findFirst().orElseGet(UniversalProduct::new);
        }
        return new UniversalProduct();
    }

    @Override
    ExtApiV2UniversalProduct getRestProduct() {
        return new ExtApiV2UniversalProduct();
    }

    @Override
    public ExtApiV2ProductType getRestProductType() {
        return ExtApiV2ProductType.UNIVERSAL_PRODUCT;
    }

    @Override
    public Class<ExtApiV2UniversalProduct> getRestProductClass() {
        return ExtApiV2UniversalProduct.class;
    }

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public void linkTravellersWithProduct(UniversalProduct product, ExtApiV2UniversalProduct restProduct, Map<String, Traveller> travellerMap) {
        product.getTravellersUids().clear();
        for (String travellerUid : restProduct.getTravellerUids()) {
            Traveller traveller = travellerMap.computeIfAbsent(travellerUid, uid -> ExtApiV2ConverterHelper.getTravellerByPassengerUid(uid, travellerMap));
            product.getTravellersUids().add(traveller.getUid());
        }
    }

    @Override
    public String getRestSystemNumber(ExtApiV2UniversalProduct restProduct) {
        return restProduct.getProductNumber();
    }

    @Override
    public ProductStatus getRestProductStatus(ExtApiV2UniversalProduct restProduct) {
        return restProduct.getProductStatus();
    }

    @Override
    public LocalDateTime getRestIssueDate(ExtApiV2UniversalProduct restProduct) {
        return restProduct.getIssueDate();
    }
}

