/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.hotel;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AvailableOption;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProviderDictData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Location;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2PassengerAdditionalInfo;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductFop;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelAdditionalService;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelAvailableOption;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelCancellationCharge;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelCommission;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelCorporateData;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelDailyRate;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelData;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelGuaranteeCard;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelLocation;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelMeal;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelPenalty;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelProviderData;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelRoom;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelServiceAvailability;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelTax;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExtApiV2HotelProductConverterHelper {
    public static ExtApiV2HotelData buildHotelData(HotelProduct product) {
        ExtApiV2HotelData result = new ExtApiV2HotelData();
        result.setHotelCity(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getHotelLocation()));
        result.setHotelCountry(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)product.getHotelCountry()));
        result.setCityProviderData(ExtApiV2HotelProductConverterHelper.convertProviderData(product.getCityProviderData()));
        result.setCountryProviderData(ExtApiV2HotelProductConverterHelper.convertProviderData(product.getCountryProviderData()));
        result.setHotelLocation(ExtApiV2HotelProductConverterHelper.convertHotelLocation(product.getLoc()));
        result.setProviderHotelCode(product.getProviderHotelCode());
        result.setHotelPropertyId(product.getHotelPropertyId());
        result.setHotelStars(product.getHotelStars());
        result.setHotelName(product.getHotelName());
        result.setHotelAddress(product.getHotelAddress());
        result.setHotelPhone(product.getHotelPhone());
        result.setHotelFax(product.getHotelFax());
        result.setHotelChainCode(product.getHotelChainCode());
        result.setHotelDescription(product.getDescription());
        return result;
    }

    public static ExtApiV2HotelCorporateData buildHotelCorporateData(HotelProduct product) {
        ExtApiV2HotelCorporateData result = new ExtApiV2HotelCorporateData();
        result.setCorporateDiscount(product.getCorporateDiscount());
        result.setAgencyContract(product.getAgencyContract());
        result.setPromoCoupon(product.getPromoCoupon());
        result.setCfCode(product.getCF());
        result.setGuaranteeType(product.getGuaranteeType());
        result.setGuaranteeCode(product.getGuaranteeCode());
        if (product.getGuaranteeCard() != null) {
            ExtApiV2HotelGuaranteeCard guaranteeCard = new ExtApiV2HotelGuaranteeCard();
            guaranteeCard.setCardType(product.getGuaranteeCard().getCardType());
            guaranteeCard.setCardNumber(product.getGuaranteeCard().getCardNumber());
            guaranteeCard.setGuaranteeType(product.getGuaranteeType());
            result.setGuaranteeCard(guaranteeCard);
        }
        return result;
    }

    public static ExtApiV2HotelRoom convertHotelRoom2Rest(List<Room> rooms) {
        if (!rooms.isEmpty()) {
            Room room = rooms.get(0);
            ExtApiV2HotelRoom restRoom = new ExtApiV2HotelRoom();
            restRoom.setUid(room.getUid());
            restRoom.setId(room.getId());
            restRoom.setOfferToken(room.getOfferToken());
            restRoom.setRoomName(room.getRoomName());
            restRoom.setRoomSize(room.getRoomSize());
            restRoom.setRateType(room.getRateType());
            restRoom.setNumberOfPeople(room.getNumberOfPeople());
            restRoom.setAdditionalInfo(room.getAdditionalInfo());
            restRoom.setCheckInDate(DateUtils.toLocalDate((Date)room.getCheckInDate()));
            restRoom.setCheckInTime(room.getCheckInTime());
            restRoom.setCheckOutDate(DateUtils.toLocalDate((Date)room.getCheckOutDate()));
            restRoom.setCheckOutTime(room.getCheckOutTime());
            restRoom.getRoomGuestsUids().addAll(room.getRoomTravellersUids());
            restRoom.setEquivalentPrice(room.getEquivalentPrice());
            restRoom.setEquivalentRate(room.getEquivalentRate());
            restRoom.setWithVat(room.getVat());
            restRoom.setEquivalentVatPrice(room.getEquivalentVatPrice());
            restRoom.setEquivalentVatRate(room.getEquivVatRate());
            restRoom.setBaseRate(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)room.getBaseRate()));
            restRoom.setBasePrice(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)room.getBasePrice()));
            for (DailyRate dailyRate : room.getDailyRates()) {
                ExtApiV2HotelDailyRate restDailyRate = new ExtApiV2HotelDailyRate();
                restDailyRate.setStartDate(DateUtils.toLocalDate((Date)dailyRate.getStartDate()));
                restDailyRate.setEndDate(DateUtils.toLocalDate((Date)dailyRate.getEndDate()));
                restDailyRate.setRate(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)dailyRate.getRate()));
                restDailyRate.setTax(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)dailyRate.getTax()));
                restDailyRate.setSurcharge(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)dailyRate.getSurcharge()));
                restRoom.getDailyRates().add(restDailyRate);
            }
            for (AvailableOption availableOption : room.getAvailableOptions()) {
                ExtApiV2HotelAvailableOption restOption = new ExtApiV2HotelAvailableOption();
                restOption.setCode(availableOption.getCode());
                restOption.setCaption(availableOption.getDisplayName());
                restOption.setOptionType(availableOption.getOptionType());
                restRoom.getAvailableOptions().add(restOption);
            }
            if (room.getMeal() != null) {
                ExtApiV2HotelMeal restMeal = new ExtApiV2HotelMeal();
                restMeal.setCode(room.getMeal().getCode());
                restMeal.setCaption(room.getMeal().getCaption());
                restRoom.setMeal(restMeal);
            }
            if (room.getAvailability() != null) {
                ExtApiV2HotelServiceAvailability restAvailability = new ExtApiV2HotelServiceAvailability();
                restAvailability.setImmediateConfirmation(room.getAvailability().getImmediateConfirmation());
                restAvailability.setPayee(room.getAvailability().getPayee());
                restRoom.setAvailability(restAvailability);
            }
            return restRoom;
        }
        return null;
    }

    public static ExtApiV2HotelCancellationCharge convertCancellationCharge2Rest(CancellationCharge cancellationCharge) {
        ExtApiV2HotelCancellationCharge restCharge = new ExtApiV2HotelCancellationCharge();
        restCharge.setStartDate(DateUtils.toLocalDateTime((Date)cancellationCharge.getStartDate()));
        restCharge.setEndDate(DateUtils.toLocalDateTime((Date)cancellationCharge.getEndDate()));
        restCharge.setPenaltyEquivalentAmount(cancellationCharge.getPenaltyEquivalentAmount());
        restCharge.setPenaltyEquivalentVatAmount(cancellationCharge.getPenaltyEquivalentVatAmount());
        restCharge.setPenaltyEquivalentVatRate(cancellationCharge.getPenaltyEquivalentVatRate());
        restCharge.setNotAvailableViaApi(cancellationCharge.getNotAvailableViaAPI());
        restCharge.setPolicyText(cancellationCharge.getPolicyText());
        if (cancellationCharge.getPenalty() != null) {
            restCharge.setPenaltyRate(cancellationCharge.getPenalty().getRate());
            restCharge.setPenalty(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)cancellationCharge.getPenalty().getMoney()));
        }
        return restCharge;
    }

    public static ExtApiV2HotelAdditionalService convertAdditionalService2Rest(AdditionalService service) {
        ExtApiV2HotelAdditionalService restService = new ExtApiV2HotelAdditionalService();
        restService.setName(service.getName());
        restService.setCode(service.getCode());
        restService.setType(service.getType());
        restService.setStatus(service.getStatus());
        restService.setCount(Integer.valueOf(service.getCount()));
        restService.setIncludedInTariff(Boolean.valueOf(service.isIncludedInTariff()));
        restService.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)service.getBaseAmount()));
        restService.setEquivalentAmount(service.getEquivalentAmount());
        restService.setEquivalentVatAmount(service.getEquivalentVatAmount());
        restService.setEquivalentVatRate(service.getEquivalentVatRate());
        return restService;
    }

    public static ExtApiV2HotelPenalty convertPenalty2Rest(Penalty penalty) {
        ExtApiV2HotelPenalty restPenalty = new ExtApiV2HotelPenalty();
        restPenalty.setName(penalty.getName());
        restPenalty.setCode(penalty.getCode());
        restPenalty.setEquivalentAmount(penalty.getEquivalentAmount());
        restPenalty.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)penalty.getBaseAmount()));
        restPenalty.setVatAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)penalty.getBaseVatAmount()));
        restPenalty.setEquivalentVatAmount(penalty.getEquivalentVatAmount());
        restPenalty.setEquivalentVatRate(penalty.getEquivalentVatRate());
        return restPenalty;
    }

    public static ExtApiV2HotelTax convertTax2Rest(HotelProductTax tax) {
        ExtApiV2HotelTax restTax = new ExtApiV2HotelTax();
        restTax.setCode(tax.getCode());
        restTax.setCollect(tax.getAddCollect());
        restTax.setEquivalentAmount(tax.getEquivalentAmount());
        restTax.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)tax.getAmount()));
        restTax.setEquivalentVatAmount(tax.getEquivalentVatAmount());
        restTax.setEquivalentVatRate(tax.getEquivalentVatRate());
        return restTax;
    }

    public static ExtApiV2HotelCommission convertHotelCommission2Rest(HotelProductCommission commission) {
        if (commission != null) {
            ExtApiV2HotelCommission restCommission = new ExtApiV2HotelCommission();
            restCommission.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)commission.getAmount()));
            restCommission.setEquivalentAmount(commission.getEquivalentAmount());
            return restCommission;
        }
        return null;
    }

    public static List<ExtApiV2HotelCommission> convertVendorCommissions2Rest(HotelProduct product) {
        ArrayList<ExtApiV2HotelCommission> result = new ArrayList<ExtApiV2HotelCommission>();
        GeneralProductContractRelationData vendorContractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
        if (vendorContractRelation != null) {
            vendorContractRelation.getCommissions().stream().map(commission -> {
                ExtApiV2HotelCommission restCommission = new ExtApiV2HotelCommission();
                restCommission.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)commission.getAmount()));
                restCommission.setEquivalentAmount(commission.getEquivalentAmount());
                return restCommission;
            }).forEach(result::add);
        }
        return result;
    }

    public static Map<String, ExtApiV2PassengerAdditionalInfo> convertProductTravellers2Rest(HotelProduct product) {
        HashMap<String, ExtApiV2PassengerAdditionalInfo> result = new HashMap<String, ExtApiV2PassengerAdditionalInfo>();
        for (Traveller traveller : product.getTravellers()) {
            ExtApiV2DictionaryWrapper value = product.getTravellersPassengerTypes().stream().filter(typeRef -> traveller.getUid().equals(typeRef.getTravellerUid())).map(typeRef -> ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)typeRef.getPassengerType())).filter(Objects::nonNull).findFirst().orElse(null);
            result.put(traveller.getUid(), value == null ? null : (ExtApiV2PassengerAdditionalInfo)ExtApiV2HotelProductConverterHelper.convertDictionaryWrapperToPassengerAdditionalInfo(value));
        }
        return result;
    }

    private static ExtApiV2DictionaryWrapper convertDictionaryWrapperToPassengerAdditionalInfo(ExtApiV2DictionaryWrapper wrapper) {
        ExtApiV2PassengerAdditionalInfo additionalInfo = new ExtApiV2PassengerAdditionalInfo();
        additionalInfo.setDictionaryType(wrapper.getDictionaryType());
        additionalInfo.getCodes().putAll(wrapper.getCodes());
        return additionalInfo;
    }

    private static ExtApiV2HotelLocation convertHotelLocation(Location location) {
        if (location != null) {
            ExtApiV2HotelLocation restLocation = new ExtApiV2HotelLocation();
            restLocation.setLatitude(location.getLatitude());
            restLocation.setLongitude(location.getLongitude());
            return restLocation;
        }
        return null;
    }

    private static ExtApiV2HotelProviderData convertProviderData(HotelProviderDictData providerDictData) {
        if (providerDictData != null) {
            ExtApiV2HotelProviderData restProviderData = new ExtApiV2HotelProviderData();
            restProviderData.setSystemCode(providerDictData.getSystemCode());
            restProviderData.setProviderCode(providerDictData.getProviderCode());
            restProviderData.setProviderName(providerDictData.getProviderName());
            return restProviderData;
        }
        return null;
    }

    public static ExtApiV2ProductFop convertProductFop2Rest(HotelProductFop productFop) {
        ExtApiV2ProductFop result = new ExtApiV2ProductFop();
        result.setUid(productFop.getUid());
        result.setCategory(GeneralProductHelper.getProductFopCategory((GeneralProductFop)productFop));
        result.setPaymentType(productFop.getType());
        result.setAmount(productFop.getAmount().getValue());
        result.setCurrency(productFop.getAmount().getCurrency());
        result.setAgent(productFop.getAgent());
        result.setOperationDate(DateUtils.toLocalDateTime((Date)productFop.getOperationDate()));
        return result;
    }
}

