/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.hotel;

import com.com.gridnine.xtrip.common.model.booking.xtriphotels.HotelGuaranteeCard;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AvailableOption;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProviderDictData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Location;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Money;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelAdditionalService;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelAvailableOption;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelCancellationCharge;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelCommission;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelCorporateData;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelDailyRate;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelData;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelLocation;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelPenalty;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelProviderData;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelRoom;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.hotel.ExtApiV2HotelTax;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public class ExtApiV2HotelRestConverterHelper {
    public static void convertRestHotelData(ExtApiV2HotelData hotelData, HotelProduct product) {
        if (hotelData != null) {
            product.setHotelLocation(ExtApiV2DictionaryConverterHelper.getGeolocationFromDictionaryWrapper((ExtApiV2DictionaryWrapper)hotelData.getHotelCity(), (LocationType)LocationType.CITY));
            if (product.getHotelLocation() == null) {
                product.setHotelLocation(DictHelper.findCityByName((String)hotelData.getHotelCityAsString()));
            }
            product.setHotelCountry(ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(Country.class, (ExtApiV2DictionaryWrapper)hotelData.getHotelCountry()));
            product.setCityProviderData(ExtApiV2HotelRestConverterHelper.convertProviderData(hotelData.getCityProviderData(), hotelData.getHotelCityAsString()));
            product.setCountryProviderData(ExtApiV2HotelRestConverterHelper.convertProviderData(hotelData.getCountryProviderData()));
            product.setLoc(ExtApiV2HotelRestConverterHelper.convertHotelLocation(hotelData.getHotelLocation()));
            product.setProviderHotelCode(hotelData.getProviderHotelCode());
            product.setHotelPropertyId(hotelData.getHotelPropertyId());
            product.setHotelStars(hotelData.getHotelStars());
            product.setHotelName(hotelData.getHotelName());
            product.setHotelAddress(hotelData.getHotelAddress());
            product.setHotelPhone(hotelData.getHotelPhone());
            product.setHotelFax(hotelData.getHotelFax());
            product.setHotelChainCode(hotelData.getHotelChainCode());
            product.setDescription(hotelData.getHotelDescription());
        }
    }

    public static void convertRestHotelCorporateData(ExtApiV2HotelCorporateData corporateData, HotelProduct product) {
        if (corporateData != null) {
            product.setCorporateDiscount(corporateData.getCorporateDiscount());
            product.setAgencyContract(corporateData.getAgencyContract());
            product.setPromoCoupon(corporateData.getPromoCoupon());
            product.setCF(corporateData.getCfCode());
            product.setGuaranteeType(corporateData.getGuaranteeType());
            product.setGuaranteeCode(corporateData.getGuaranteeCode());
            if (corporateData.getGuaranteeCard() != null) {
                HotelGuaranteeCard guaranteeCard = new HotelGuaranteeCard();
                guaranteeCard.setCardType(corporateData.getGuaranteeCard().getCardType());
                guaranteeCard.setCardNumber(corporateData.getGuaranteeCard().getCardNumber());
                guaranteeCard.setType(corporateData.getGuaranteeCard().getGuaranteeType());
                product.setGuaranteeCard(guaranteeCard);
            }
        }
    }

    public static void convertRestRoom(ExtApiV2HotelRoom restRoom, ExtApiV2HotelData hotelData, List<Room> rooms) {
        if (restRoom != null) {
            Room room = rooms.stream().filter(r -> MiscUtil.equals((Object)restRoom.getUid(), (Object)r.getUid())).findFirst().orElse(new Room());
            room.setId(restRoom.getId());
            room.setOfferToken(restRoom.getOfferToken());
            room.setRoomName(restRoom.getRoomName());
            room.setRoomSize(restRoom.getRoomSize());
            room.setRateType(restRoom.getRateType());
            room.setNumberOfPeople(restRoom.getNumberOfPeople());
            room.setAdditionalInfo(restRoom.getAdditionalInfo());
            room.setCheckInDate(DateUtils.toJavaDate((LocalDate)restRoom.getCheckInDate()));
            room.setCheckInTime(restRoom.getCheckInTime());
            room.setCheckOutDate(DateUtils.toJavaDate((LocalDate)restRoom.getCheckOutDate()));
            room.setCheckOutTime(restRoom.getCheckOutTime());
            room.getRoomTravellersUids().clear();
            room.getRoomTravellersUids().addAll(restRoom.getRoomGuestsUids());
            room.setEquivalentPrice(restRoom.getEquivalentPrice());
            room.setEquivalentRate(restRoom.getEquivalentRate());
            room.setVat(restRoom.isWithVat());
            room.setEquivalentVatPrice(restRoom.getEquivalentVatPrice());
            room.setEquivVatRate(restRoom.getEquivalentVatRate());
            room.setBaseRate(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restRoom.getBaseRate()));
            room.setBasePrice(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restRoom.getBasePrice()));
            room.getDailyRates().clear();
            for (ExtApiV2HotelDailyRate restDailyRate : restRoom.getDailyRates()) {
                DailyRate dailyRate = new DailyRate();
                dailyRate.setStartDate(DateUtils.toJavaDate((LocalDate)restDailyRate.getStartDate()));
                dailyRate.setEndDate(DateUtils.toJavaDate((LocalDate)restDailyRate.getEndDate()));
                dailyRate.setRate(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restDailyRate.getRate()));
                dailyRate.setTax(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restDailyRate.getTax()));
                dailyRate.setSurcharge(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restDailyRate.getSurcharge()));
                room.getDailyRates().add(dailyRate);
            }
            room.getAvailableOptions().clear();
            for (ExtApiV2HotelAvailableOption restOption : restRoom.getAvailableOptions()) {
                AvailableOption option = new AvailableOption();
                option.setCode(restOption.getCode());
                option.setDisplayName(restOption.getCaption());
                option.setOptionType(restOption.getOptionType());
                room.getAvailableOptions().add(option);
            }
            if (restRoom.getMeal() != null) {
                Meal meal = new Meal();
                meal.setCode(restRoom.getMeal().getCode());
                meal.setCaption(restRoom.getMeal().getCaption());
                room.setMeal(meal);
            }
            if (restRoom.getAvailability() != null) {
                HotelsServiceAvailability availability = new HotelsServiceAvailability();
                availability.setImmediateConfirmation(restRoom.getAvailability().isImmediateConfirmation());
                availability.setPayee(restRoom.getAvailability().getPayee());
                room.setAvailability(availability);
            }
            if (hotelData != null) {
                room.setHotelCardNumber(hotelData.getHotelPropertyId());
            }
            rooms.clear();
            rooms.add(room);
        }
    }

    public static CancellationCharge convertRestCancellationCharge(ExtApiV2HotelCancellationCharge restCharge) {
        CancellationCharge cancellationCharge = new CancellationCharge();
        cancellationCharge.setStartDate(DateUtils.toJavaDate((LocalDateTime)restCharge.getStartDate()));
        cancellationCharge.setEndDate(DateUtils.toJavaDate((LocalDateTime)restCharge.getEndDate()));
        cancellationCharge.setPenaltyEquivalentAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restCharge.getPenaltyEquivalentAmount()));
        cancellationCharge.setPenaltyEquivalentVatAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restCharge.getPenaltyEquivalentVatAmount()));
        cancellationCharge.setPenaltyEquivalentVatRate(restCharge.getPenaltyEquivalentVatRate());
        cancellationCharge.setNotAvailableViaAPI(restCharge.isNotAvailableViaApi());
        cancellationCharge.setPolicyText(restCharge.getPolicyText());
        if (restCharge.getPenalty() != null) {
            RateMoney penalty = new RateMoney();
            penalty.setRate(restCharge.getPenaltyRate());
            penalty.setMoney(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restCharge.getPenalty()));
            cancellationCharge.setPenalty(penalty);
        }
        return cancellationCharge;
    }

    public static AdditionalService convertRestAdditionalService(ExtApiV2HotelAdditionalService restService) {
        AdditionalService service = new AdditionalService();
        service.setName(restService.getName());
        service.setCode(restService.getCode());
        service.setType(restService.getType());
        service.setStatus(restService.getStatus());
        service.setCount(restService.getCount().intValue());
        service.setIncludedInTariff(restService.isIncludedInTariff().booleanValue());
        service.setBaseAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restService.getAmount()));
        service.setEquivalentAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restService.getEquivalentAmount()));
        service.setEquivalentVatAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restService.getEquivalentVatAmount()));
        service.setEquivalentVatRate(restService.getEquivalentVatRate());
        return service;
    }

    public static Penalty convertPenalty2Rest(ExtApiV2HotelPenalty restPenalty) {
        Penalty penalty = new Penalty();
        penalty.setName(restPenalty.getName());
        penalty.setCode(restPenalty.getCode());
        penalty.setEquivalentAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restPenalty.getEquivalentAmount()));
        penalty.setBaseAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restPenalty.getAmount()));
        penalty.setBaseVatAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restPenalty.getVatAmount()));
        penalty.setEquivalentVatAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restPenalty.getEquivalentVatAmount()));
        penalty.setEquivalentVatRate(restPenalty.getEquivalentVatRate());
        return penalty;
    }

    public static HotelProductTax convertTax2Rest(ExtApiV2HotelTax restTax) {
        HotelProductTax tax = new HotelProductTax();
        tax.setCode(restTax.getCode());
        tax.setAddCollect(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restTax.getCollect()));
        tax.setEquivalentAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restTax.getEquivalentAmount()));
        tax.setAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restTax.getAmount()));
        tax.setEquivalentVatAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restTax.getEquivalentVatAmount()));
        tax.setEquivalentVatRate(restTax.getEquivalentVatRate());
        return tax;
    }

    public static HotelProductCommission convertRestHotelCommission(ExtApiV2HotelCommission restCommission) {
        if (restCommission != null) {
            HotelProductCommission commission = new HotelProductCommission();
            commission.setAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restCommission.getAmount()));
            commission.setEquivalentAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restCommission.getEquivalentAmount()));
            return commission;
        }
        return null;
    }

    private static Location convertHotelLocation(ExtApiV2HotelLocation restLocation) {
        if (restLocation != null) {
            Location location = new Location();
            location.setLatitude(location.getLatitude());
            location.setLongitude(location.getLongitude());
            return location;
        }
        return null;
    }

    private static HotelProviderDictData convertProviderData(ExtApiV2HotelProviderData restProviderData) {
        return ExtApiV2HotelRestConverterHelper.convertProviderData(restProviderData, null);
    }

    private static HotelProviderDictData convertProviderData(ExtApiV2HotelProviderData restProviderData, String providerName) {
        HotelProviderDictData providerDictData = new HotelProviderDictData();
        if (restProviderData != null) {
            providerDictData.setSystemCode(restProviderData.getSystemCode());
            providerDictData.setProviderCode(restProviderData.getProviderCode());
            providerDictData.setProviderName(restProviderData.getProviderName());
            return providerDictData;
        }
        if (TextUtil.nonBlank((String)providerName)) {
            providerDictData.setProviderName(providerName);
            return providerDictData;
        }
        return null;
    }
}

