/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.rail;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrierReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2PassengerAdditionalInfo;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductFop;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.dict.ExtApiV2RailwayCarrierReference;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.rail.ExtApiV2CarriageType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.rail.ExtApiV2RailProductPrice;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.rail.ExtApiV2RailSegmentPrice;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.rail.ExtApiV2RailwaySegment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.rail.ExtApiV2ReservedSeat;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtApiV2RailConverterHelper {
    private static Map<CarriageType, ExtApiV2CarriageType> carriageTypeMap = new HashMap<CarriageType, ExtApiV2CarriageType>();

    public static ExtApiV2RailProductPrice convertProductPrice2Rest(RailwayProduct product) {
        ExtApiV2RailProductPrice price = new ExtApiV2RailProductPrice();
        price.setFare(product.getEquivalentFare());
        price.setFareVAT(product.getEquivalentVAT());
        price.setPenalty(product.getPenalty());
        price.setServiceFare(product.getServiceFare());
        price.setServiceVAT(product.getServiceVAT());
        price.setCurrency(product.getGdsCurrency());
        return price;
    }

    public static void convertRestProductPrice(RailwayProduct product, ExtApiV2RailProductPrice price) {
        if (price != null) {
            BigDecimal fare = ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)price.getFare());
            BigDecimal fareVat = ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)price.getFareVAT());
            BigDecimal serviceFare = ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)price.getServiceFare());
            BigDecimal serviceVat = ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)price.getServiceVAT());
            BigDecimal penalty = ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)price.getPenalty());
            product.setEquivalentFare(fare);
            product.setEquivalentVAT(fareVat);
            product.setServiceFare(serviceFare);
            product.setServiceVAT(serviceVat);
            product.setPenalty(penalty);
            product.setGdsCurrency(price.getCurrency());
            product.setTotalEquivalentFare(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, serviceFare}));
            product.setTotalEquivalentVAT(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fareVat, serviceVat}));
        }
    }

    public static List<ExtApiV2RailwaySegment> convertRailSegments2Rest(List<RailwaySegment> segments) {
        return segments.stream().map(segment -> {
            ExtApiV2RailwaySegment restSegment = new ExtApiV2RailwaySegment();
            restSegment.setUid(segment.getUid());
            restSegment.setNumber(segment.getNumber());
            restSegment.setDepartureStation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getDepartureStation()));
            restSegment.setDepartureDate(DateUtils.toLocalDateTime((Date)segment.getDepartureDate()));
            restSegment.setArrivalStation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getArriveStation()));
            restSegment.setArrivalDate(DateUtils.toLocalDateTime((Date)segment.getArriveDate()));
            restSegment.setCarrier(ExtApiV2RailConverterHelper.convertCarrier2RestReference((RailwayCarrier)DictHelper.resolve((DictionaryReference)segment.getCarrier())));
            restSegment.setTrainNumber(segment.getTrainNumber());
            restSegment.setCarriageNumber(segment.getCarriageNumber());
            restSegment.setCarriageType(ExtApiV2RailConverterHelper.convertCarriageType2Rest(segment.getCarriageType()));
            restSegment.getSeats().addAll(segment.getPlaces());
            restSegment.setEReg(segment.isHasEReg());
            restSegment.setERegPossibility(segment.isERegEnabled());
            restSegment.setEquivalentFare(segment.getEquivalentFare());
            restSegment.setSlot(segment.getSlot());
            restSegment.setServiceClass(segment.getServiceClass());
            restSegment.setCompartmentType(segment.getCompartmentType());
            if (segment.getFare() != null) {
                ExtApiV2RailSegmentPrice segmentPrice = new ExtApiV2RailSegmentPrice();
                segmentPrice.setValue(segment.getFare().getValue());
                segmentPrice.setCurrency(segment.getFare().getCurrency());
                restSegment.setFare(segmentPrice);
            }
            return restSegment;
        }).collect(Collectors.toList());
    }

    public static void convertRestRailwaySegments(List<ExtApiV2RailwaySegment> restSegments, List<RailwaySegment> segments) {
        List resultSegments = restSegments.stream().map(restSeg -> {
            RailwaySegment segment = segments.stream().filter(seg -> MiscUtil.equals((Object)seg.getUid(), (Object)restSeg.getUid())).findFirst().orElse(new RailwaySegment());
            segment.setDepartureStation(ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(RailwayStation.class, (ExtApiV2DictionaryWrapper)restSeg.getDepartureStation()));
            segment.setDepartureDate(DateUtils.toJavaDate((LocalDateTime)restSeg.getDepartureDate()));
            segment.setLocalDepartureDate(DateUtils.toJavaDate((LocalDateTime)restSeg.getLocalDepartureDate()));
            segment.setArriveStation(ExtApiV2DictionaryConverterHelper.convertDictionaryWrapper(RailwayStation.class, (ExtApiV2DictionaryWrapper)restSeg.getArrivalStation()));
            segment.setLocalArriveDate(DateUtils.toJavaDate((LocalDateTime)restSeg.getLocalArrivalDate()));
            segment.setArriveDate(DateUtils.toJavaDate((LocalDateTime)restSeg.getArrivalDate()));
            segment.setNumber(restSeg.getNumber());
            segment.setTrainNumber(restSeg.getTrainNumber());
            segment.setCarriageNumber(restSeg.getCarriageNumber());
            segment.setCarrier((DictionaryReference)ExtApiV2RailConverterHelper.convertRestCarrierReference(restSeg.getCarrier()));
            segment.setCarriageType(ExtApiV2RailConverterHelper.convertRestCarriageType(restSeg.getCarriageType()));
            segment.setHasEReg(restSeg.isEReg());
            segment.setERegEnabled(restSeg.isERegPossibility());
            segment.setSlot(restSeg.getSlot());
            segment.setServiceClass(restSeg.getServiceClass());
            segment.setCompartmentType(restSeg.getCompartmentType());
            segment.setEquivalentFare(restSeg.getEquivalentFare());
            segment.getPlaces().clear();
            segment.getPlaces().addAll(restSeg.getSeats());
            if (restSeg.getFare() != null) {
                Money fare = new Money();
                fare.setValue(restSeg.getFare().getValue());
                fare.setCurrency(restSeg.getFare().getCurrency());
                segment.setFare(fare);
            }
            return segment;
        }).collect(Collectors.toList());
        segments.clear();
        segments.addAll(resultSegments);
    }

    public static List<ExtApiV2ReservedSeat> convertReservedSeats2Rest(List<ReservedSeat> reservedSeats) {
        return reservedSeats.stream().map(seat -> {
            ExtApiV2ReservedSeat result = new ExtApiV2ReservedSeat();
            result.setSegmentNumber(seat.getSegment() != null ? Integer.valueOf(seat.getSegment().getNumber()) : null);
            result.setEquivalentFare(seat.getEquivalentFare());
            result.setVat(seat.getEquivalentVAT());
            if (seat.getFare() != null) {
                ExtApiV2RailSegmentPrice fare = new ExtApiV2RailSegmentPrice();
                fare.setValue(seat.getFare().getValue());
                fare.setCurrency(seat.getFare().getCurrency());
                result.setFare(fare);
            }
            return result;
        }).collect(Collectors.toList());
    }

    public static void convertRestReservedSeat(List<ExtApiV2ReservedSeat> restSeats, List<ReservedSeat> seats, List<RailwaySegment> railwaySegments) {
        seats.clear();
        seats.addAll(restSeats.stream().map(restSeat -> {
            ReservedSeat seat = new ReservedSeat();
            seat.setEquivalentFare(restSeat.getEquivalentFare());
            seat.setEquivalentVAT(restSeat.getVat());
            railwaySegments.stream().filter(segment -> MiscUtil.equals((Object)segment.getNumber(), (Object)restSeat.getSegmentNumber())).findFirst().ifPresent(arg_0 -> ((ReservedSeat)seat).setSegment(arg_0));
            if (restSeat.getFare() != null) {
                Money fare = new Money();
                fare.setValue(restSeat.getFare().getValue());
                fare.setCurrency(restSeat.getFare().getCurrency());
                seat.setFare(fare);
            }
            return seat;
        }).collect(Collectors.toList()));
    }

    public static Map<String, ExtApiV2PassengerAdditionalInfo> convertProductTravellers2Rest(RailwayProduct product) {
        HashMap<String, ExtApiV2PassengerAdditionalInfo> result = new HashMap<String, ExtApiV2PassengerAdditionalInfo>();
        for (Traveller traveller : product.getPassengers()) {
            DictionaryReference passengerType = RailwayProductHelper.getPassengerType((RailwayProduct)product, (Traveller)traveller);
            ExtApiV2DictionaryWrapper value = ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)passengerType);
            result.put(traveller.getUid(), value == null ? null : (ExtApiV2PassengerAdditionalInfo)ExtApiV2RailConverterHelper.convertDictionaryWrapperToPassengerAdditionalInfo(value));
        }
        return result;
    }

    private static ExtApiV2DictionaryWrapper convertDictionaryWrapperToPassengerAdditionalInfo(ExtApiV2DictionaryWrapper wrapper) {
        ExtApiV2PassengerAdditionalInfo additionalInfo = new ExtApiV2PassengerAdditionalInfo();
        additionalInfo.setDictionaryType(wrapper.getDictionaryType());
        additionalInfo.getCodes().putAll(wrapper.getCodes());
        return additionalInfo;
    }

    public static ExtApiV2RailwayCarrierReference convertCarrier2RestReference(RailwayCarrier railwayCarrier) {
        if (railwayCarrier != null) {
            ExtApiV2RailwayCarrierReference result = new ExtApiV2RailwayCarrierReference();
            result.setCode(railwayCarrier.getCode());
            result.setInn(railwayCarrier.getInn());
            result.setKpp(railwayCarrier.getKpp());
            result.setName((String)MiscUtil.findByLocale((Map)railwayCarrier.getTranslations(), (Locale)LocaleHelper.getCurrentLocale()));
            return result;
        }
        return null;
    }

    private static RailwayCarrierReference convertRestCarrierReference(ExtApiV2RailwayCarrierReference restRef) {
        RailwayCarrier carrier = null;
        if (restRef != null) {
            if (TextUtil.nonBlank((String)restRef.getCode())) {
                carrier = (RailwayCarrier)DictionaryCache.get().findByCode(RailwayCarrier.class, restRef.getCode());
            }
            if (carrier == null) {
                Set search = DictionaryCache.get().search(RailwayCarrier.class, DictSearchCriterion.eq((String)RailwayCarrier.Property.inn.name(), (Object)restRef.getInn()));
                carrier = search.size() == 1 ? (RailwayCarrier)search.iterator().next() : (RailwayCarrier)search.stream().filter(railCarrier -> MiscUtil.equals((Object)railCarrier.getKpp(), (Object)restRef.getKpp())).findFirst().orElse(null);
            }
        }
        return carrier != null ? carrier.toReference() : null;
    }

    private static ExtApiV2CarriageType convertCarriageType2Rest(CarriageType type) {
        return carriageTypeMap.get(type);
    }

    private static CarriageType convertRestCarriageType(ExtApiV2CarriageType type) {
        return (CarriageType)CollectionUtil.getKeyByValue(carriageTypeMap, (Object)type);
    }

    public static ExtApiV2ProductFop convertProductFop2Rest(RailwayProductFop productFop) {
        ExtApiV2ProductFop result = new ExtApiV2ProductFop();
        result.setUid(productFop.getUid());
        result.setCategory(RailwayProductHelper.getProductFopCategory((RailwayProductFop)productFop));
        result.setPaymentType(productFop.getType());
        result.setAmount(productFop.getAmount().getValue());
        result.setCurrency(productFop.getAmount().getCurrency());
        result.setAgent(productFop.getAgent());
        result.setOperationDate(DateUtils.toLocalDateTime((Date)productFop.getOperationDate()));
        return result;
    }

    static {
        carriageTypeMap.put(CarriageType.L, ExtApiV2CarriageType.FIRST_CLASS);
        carriageTypeMap.put(CarriageType.M, ExtApiV2CarriageType.SOFT);
        carriageTypeMap.put(CarriageType.K, ExtApiV2CarriageType.SECOND_CLASS);
        carriageTypeMap.put(CarriageType.P, ExtApiV2CarriageType.THIRD_CLASS);
        carriageTypeMap.put(CarriageType.S, ExtApiV2CarriageType.SITTING);
        carriageTypeMap.put(CarriageType.O, ExtApiV2CarriageType.COMMON);
    }
}

