/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.shipment;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2DeletedShipment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2Shipment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2ShipmentDocumentData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2ShipmentConvertProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference currentUser = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer shipmentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        Date deletedDate = (Date)ctx.getObject((Enum)IBusFinanceContextKeys.SHIPMENT_DELETED_DATE);
        if (deletedDate != null) {
            ExtApiV2DeletedShipment restShipment = new ExtApiV2DeletedShipment();
            restShipment.setNumber(((Shipment)shipmentContainer.getEntity()).getNumber());
            restShipment.setDeletedDate(MiscUtil.toLocalDateTime((Date)deletedDate));
            restShipment.setDeleted(true);
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)restShipment);
            return;
        }
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        String uid = shipmentContainer.getUid();
        String number = shipment.getNumber();
        LocalDateTime date = MiscUtil.toLocalDateTime((Date)shipment.getDate());
        List billingItems = FinanceDocumentHelper.getBillingItems((List)shipment.getBillingItems(), (EntityStorageContext)storageContext);
        BigDecimal amount = this.getAmount(billingItems);
        BigDecimal vatAmount = this.getVatAmount(billingItems, amount);
        if (billingItems.isEmpty()) {
            amount = shipment.getTotalAmountCachedValue();
            vatAmount = shipment.getTotalVatAmountCachedValue();
        }
        List restDocuments = shipment.getFinanceDocuments().stream().map(doc -> EntityStorageHelper.resolve((EntityReference)doc, (EntityStorageContext)storageContext)).filter(EntityStorageHelper::nonEmpty).map(doc -> {
            ExtApiV2ShipmentDocumentData restDocument = new ExtApiV2ShipmentDocumentData();
            restDocument.setNumber(((FinanceDocument)doc.getEntity()).getNumber());
            restDocument.setType(((FinanceDocument)doc.getEntity()).getType());
            List finDocBillingItems = FinanceDocumentHelper.getBillingItems((List)((FinanceDocument)doc.getEntity()).getBillingItems(), (EntityStorageContext)storageContext);
            BigDecimal finDocAmount = this.getAmount(finDocBillingItems);
            restDocument.setAmount(finDocAmount);
            restDocument.setVatAmount(this.getVatAmount(finDocBillingItems, finDocAmount));
            return restDocument;
        }).collect(Collectors.toList());
        String currency = Optional.ofNullable(shipment.getCurrency()).map(DictionaryReference::getCode).orElse(null);
        ExtApiV2Shipment restShipment = new ExtApiV2Shipment();
        restShipment.setUid(uid);
        restShipment.setNumber(number);
        restShipment.setDate(date);
        restShipment.setAmount(amount);
        restShipment.setVatAmount(vatAmount);
        restShipment.setCurrency(currency);
        restShipment.getDocuments().clear();
        restShipment.getDocuments().addAll(restDocuments);
        restShipment.setModifiedDate(MiscUtil.toLocalDateTime((Date)shipmentContainer.getModified()));
        restShipment.setClient(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)shipment.getCustomer()));
        restShipment.setExportedToSbis(shipment.isExportedToSbis());
        restShipment.setSentToMail(shipment.isSentToEmail());
        restShipment.setLastExportToSbisDate(MiscUtil.toLocalDateTime((Date)shipment.getLastExportToSbisDate()));
        ExtApiV2ConverterHelper.fillExportInfoToRest((EntityReference<Shipment>)shipmentContainer.toReference(), restShipment, (EntityReference<Person>)currentUser, (EntityReference<Person>)shipment.getAgent());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)restShipment);
    }

    private BigDecimal getAmount(List<BillingItem> billingItems) {
        return billingItems.stream().map(item -> Optional.ofNullable(item.getAmount()).map(VatAmount::getTotal).orElse(null)).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
    }

    private BigDecimal getVatAmount(List<BillingItem> billingItems, BigDecimal amount) {
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, MiscUtil.negate((BigDecimal)billingItems.stream().map(item -> Optional.ofNullable(item.getAmount()).map(VatAmount::getValue).orElse(null)).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null))});
    }
}

