/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.shipment;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.profile.TrashBinItemIndex;
import com.gridnine.xtrip.common.model.profile.TrashBinItemType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2GetShipmentParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2ShipmentMessages;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Optional;

public class ExtApiV2ShipmentGetLoadShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ExtApiV2GetShipmentParameters parameters = (ExtApiV2GetShipmentParameters)context.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.number.name(), (Object)parameters.getNumber()));
        List<ShipmentIndex> indexes = IbePermissionManager.secureSearch(ShipmentIndex.class, query);
        if (indexes.size() > 1) {
            throw Xeption.forEndUser((String)ExtApiV2ShipmentMessages.getShipmentWithNumberMultipleFound((String)parameters.getNumber()).getText(), (Object[])new Object[0]);
        }
        if (indexes.size() == 0) {
            EntityContainer<Shipment> deletedShipmentCtr = this.findDeletedShipment(parameters.getNumber(), context);
            if (deletedShipmentCtr != null) {
                context.putObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER, deletedShipmentCtr);
                return;
            }
            throw Xeption.forEndUser((String)ExtApiV2ShipmentMessages.getShipmentWithNumberNotFound((String)parameters.getNumber()).getText(), (Object[])new Object[0]);
        }
        EntityContainer shipment = Optional.ofNullable(IbePermissionManager.secureResolve(indexes.get(0).getSource(), StandardRestrictionResourceOperations.VIEW)).orElse(null);
        if (shipment == null) {
            throw Xeption.forEndUser((String)ExtApiV2ShipmentMessages.getShipmentLoadFailed((String)indexes.get(0).getSource().toString()).getText(), (Object[])new Object[0]);
        }
        context.putObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER, (Object)shipment);
    }

    private EntityContainer<Shipment> findDeletedShipment(String number, MessageContext context) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TrashBinItemIndex.Property.type.name(), (Object)TrashBinItemType.SHIPMENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TrashBinItemIndex.Property.number.name(), (Object)number));
        List indices = EntityStorage.get().search(TrashBinItemIndex.class, query).getData();
        if (indices.size() > 1) {
            throw Xeption.forEndUser((String)ExtApiV2ShipmentMessages.getShipmentDeletedWithNumberMultipleFound((String)number).getText(), (Object[])new Object[0]);
        }
        if (indices.size() == 0) {
            return null;
        }
        EntityContainer trashBinItem = EntityStorage.get().resolve(((TrashBinItemIndex)indices.get(0)).getSource());
        if (EntityStorageHelper.isEmpty((EntityContainer)trashBinItem) || ((TrashBinItem)trashBinItem.getEntity()).getRestoreData() == null || ((TrashBinItem)trashBinItem.getEntity()).getRestoreData().getVersions().isEmpty()) {
            throw Xeption.forEndUser((String)ExtApiV2ShipmentMessages.getShipmentDeletedLoadFailed((String)((TrashBinItemIndex)indices.get(0)).getSource().toString()).getText(), (Object[])new Object[0]);
        }
        EntityContainer shipmentContainer = (EntityContainer)((TrashBinItem)trashBinItem.getEntity()).getRestoreData().getVersions().get(0);
        if (EntityStorageHelper.isEmpty((EntityContainer)shipmentContainer)) {
            throw Xeption.forEndUser((String)ExtApiV2ShipmentMessages.getShipmentDeletedLoadFailed((String)((TrashBinItemIndex)indices.get(0)).getSource().toString()).getText(), (Object[])new Object[0]);
        }
        boolean granted = IbePermissionManager.isEntityGranted(shipmentContainer, StandardRestrictionResourceOperations.VIEW);
        if (!granted) {
            throw Xeption.forEndUser((String)ExtApiV2ShipmentMessages.getShipmentDeletedLoadFailed((String)((TrashBinItemIndex)indices.get(0)).getSource().toString()).getText(), (Object[])new Object[0]);
        }
        context.putObject((Enum)IBusFinanceContextKeys.SHIPMENT_DELETED_DATE, (Object)((TrashBinItemIndex)indices.get(0)).getDeleted());
        return shipmentContainer;
    }
}

