/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.shipment;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.ExportCategory;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.TrashBinItemIndex;
import com.gridnine.xtrip.common.model.profile.TrashBinItemType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.security.ExtApiV2SecurityHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2GetShipmentsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2GetShipmentsResult;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2Shipment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

public class ExtApiV2ShipmentGetShipmentsByLastUploadDateProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference currentUser = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        ExtApiV2GetShipmentsParameters params = (ExtApiV2GetShipmentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ExtApiV2GetShipmentsResult restResult = new ExtApiV2GetShipmentsResult();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)restResult);
        SearchQuery documentsQuery = new SearchQuery();
        documentsQuery.getCriteria().getCriterions().add(SearchCriterion.between((String)ExportDocumentIndex.Property.lastCommunicationDate.name(), (Object)MiscUtil.toDate((LocalDateTime)params.getStartDate()), (Object)MiscUtil.toDate((LocalDateTime)params.getEndDate())));
        documentsQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExportDocumentIndex.Property.exportCategory.name(), (Object)ExportCategory.SHIPMENTS_XML));
        documentsQuery.getCriteria().getOrders().put(ExportDocumentIndex.Property.createDate.name(), SortOrder.DESC);
        documentsQuery.getPreferredProperties().add(ExportDocumentIndex.Property.createDate.name());
        documentsQuery.getPreferredProperties().add(ExportDocumentIndex.Property.status.name());
        documentsQuery.getPreferredProperties().add(ExportDocumentIndex.Property.object.name());
        documentsQuery.getPreferredProperties().add(ExportDocumentIndex.Property.lastCommunicationDate.name());
        HashMap<String, ExportDocumentIndex> shipmentUids2ExportDocs = new HashMap<String, ExportDocumentIndex>();
        EntityStorage.get().search(ExportDocumentIndex.class, documentsQuery).getData().forEach(docIndex -> shipmentUids2ExportDocs.computeIfAbsent(docIndex.getObject().getUid(), uid -> docIndex));
        if (shipmentUids2ExportDocs.isEmpty()) {
            return;
        }
        SearchQuery shipmentsQuery = new SearchQuery();
        shipmentsQuery.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])shipmentUids2ExportDocs.keySet().toArray()));
        shipmentsQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.supplier.name(), (Object)salesContext.getSubagency()));
        ExtApiV2ConverterHelper.addPreferredPropertiesToShipmentQuery(shipmentsQuery);
        for (ShipmentIndex index : ExtApiV2SecurityHelper.secureSearch((EntityReference)currentUser, ShipmentIndex.class, (SearchQuery)shipmentsQuery)) {
            ExtApiV2Shipment restShipment = new ExtApiV2Shipment();
            ExtApiV2ConverterHelper.fillStandardFieldsAndFindocsToRest(index, (EntityReference<Person>)currentUser, restShipment);
            ExtApiV2ConverterHelper.fillExportInfoToRest((EntityReference<Shipment>)index.getSource(), restShipment, (EntityReference<Person>)index.getAgent(), shipmentUids2ExportDocs);
            restResult.getShipments().add(restShipment);
        }
        if (params.isIncludeDeleted()) {
            SearchQuery deletedQuery = new SearchQuery();
            deletedQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TrashBinItemIndex.Property.type.name(), (Object)TrashBinItemType.SHIPMENT));
            deletedQuery.getCriteria().getCriterions().add(SearchCriterion.in((String)TrashBinItemIndex.Property.deletedUid.name(), (Object[])shipmentUids2ExportDocs.keySet().toArray()));
            deletedQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TrashBinItemIndex.Property.supplier.name(), (Object)salesContext.getSubagency()));
            List indices = EntityStorage.get().search(TrashBinItemIndex.class, deletedQuery).getData();
            for (TrashBinItemIndex index : indices) {
                restResult.getShipments().add(ExtApiV2ConverterHelper.convertDeletedShipmentToRest(index));
            }
        }
    }
}

