/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.universalProduct;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameter;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

public class ExtApiV2UniversalProductConverterHelper {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    private static final ThreadLocal<SimpleDateFormat> DATE_TIME_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"));

    public static JSONObject convertCustomParameterValue2Rest(UniversalProductCustomParameter customParameter, EntityContainer<UniversalProductDescription> description) {
        block5: for (UniversalProductCustomParameterDescription customParameterDescription : ((UniversalProductDescription)description.getEntity()).getCustomParameters()) {
            Object val;
            if (!TextUtil.isSame((String)customParameter.getId(), (String)customParameterDescription.getId()) || (val = customParameter.getValue()) == null) continue;
            JSONObject json = new JSONObject();
            switch (customParameterDescription.getType()) {
                case DATE: {
                    if (!(val instanceof Date)) continue block5;
                    json.put(customParameter.getId(), (Object)DATE_FORMATTER.get().format((Date)val));
                    return json;
                }
                case DATE_TIME: {
                    if (!(val instanceof Date)) continue block5;
                    json.put(customParameter.getId(), (Object)DATE_TIME_FORMATTER.get().format((Date)val));
                    return json;
                }
                case DICTIONARY: {
                    if (!(val instanceof DictionaryReference)) continue block5;
                    JSONObject dictionary = new JSONObject();
                    dictionary.put("code", (Object)((DictionaryReference)val).getCode());
                    dictionary.put("caption", (Object)((DictionaryReference)val).getCaption());
                    json.put(customParameter.getId(), (Object)dictionary);
                    return json;
                }
            }
            json.put(customParameter.getId(), val);
            return json;
        }
        return null;
    }

    public static void convertRestCustomParameters(List<JSONObject> restCustomParameters, List<UniversalProductCustomParameter> customParameters, EntityContainer<UniversalProductDescription> description) throws ParseException, ClassNotFoundException {
        for (JSONObject restCustomParameter : restCustomParameters) {
            String key = restCustomParameter.keys().next().toString();
            boolean found = false;
            for (UniversalProductCustomParameterDescription customParameterDescription : ((UniversalProductDescription)description.getEntity()).getCustomParameters()) {
                if (!TextUtil.isSame((String)key, (String)customParameterDescription.getId())) continue;
                found = true;
                UniversalProductCustomParameter universalProductCustomParameter = new UniversalProductCustomParameter();
                universalProductCustomParameter.setId(key);
                Object value = restCustomParameter.get(key);
                switch (customParameterDescription.getType()) {
                    case STRING: {
                        if (value instanceof String) {
                            universalProductCustomParameter.setValue(value);
                            break;
                        }
                    }
                    case BOOLEAN: {
                        if (value instanceof Boolean) {
                            universalProductCustomParameter.setValue(value);
                            break;
                        }
                    }
                    case NUMBER: {
                        if (value instanceof Number) {
                            universalProductCustomParameter.setValue((Object)BigDecimal.valueOf(value instanceof Double ? (Double)value : (double)((Integer)value).intValue()));
                            break;
                        }
                    }
                    case DATE: {
                        if (value instanceof String) {
                            universalProductCustomParameter.setValue((Object)DATE_FORMATTER.get().parse(value.toString()));
                            break;
                        }
                    }
                    case DATE_TIME: {
                        if (value instanceof String) {
                            universalProductCustomParameter.setValue((Object)DATE_TIME_FORMATTER.get().parse(value.toString()));
                            break;
                        }
                    }
                    case DICTIONARY: {
                        if (value instanceof JSONObject) {
                            String code = ((JSONObject)value).getString("code");
                            Class<?> cls = Class.forName((String)customParameterDescription.getTypeAdditionalInfo());
                            BaseDictionary dictionary = DictionaryCache.get().findByCode(cls, code);
                            if (dictionary == null) {
                                throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getDictionaryCodeNotFound((String)code).getText(), (Object[])new Object[0]);
                            }
                            universalProductCustomParameter.setValue((Object)dictionary.toReference());
                            break;
                        }
                    }
                    default: {
                        throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getIncorrectCustomParameterValue((String)customParameterDescription.getId()).getText(), (Object[])new Object[0]);
                    }
                }
                customParameters.add(universalProductCustomParameter);
            }
            if (found) continue;
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getCustomParameterNotFound((String)key).getText(), (Object[])new Object[0]);
        }
    }
}

