/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.logger;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.JsonMarshaller;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamWriter;
import org.joda.time.LocalDateTime;

public class ExtApiLoggerDocumentBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void BuildLogDocument(Map<String, Object> data, String url, String error) throws Exception {
        EntityContainer container = (EntityContainer)data.get(IBusBookingContextKeys.BOOKING_FILE_CONTAINER.name());
        RestServiceProvider.Operation restOperation = (RestServiceProvider.Operation)data.get(IBusRestContextKeys.REST_OPERATION.name());
        Validatable validatedParams = (Validatable)data.get(IBusRestContextKeys.REST_PARAMS.name());
        JsonMarshaller jsonMarshaller = (JsonMarshaller)data.get(IBusRestContextKeys.JSON_MARSHALLER.name());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(baos));){
            writer.writeStartDocument();
            writer.writeStartElement("extApiLogFile");
            writer.writeStartElement("date");
            writer.writeCharacters(LocalDateTime.now().toString());
            writer.writeEndElement();
            writer.writeStartElement("requestURL");
            writer.writeCharacters(url);
            writer.writeEndElement();
            writer.writeStartElement("method");
            writer.writeCharacters(restOperation.getMethod());
            writer.writeEndElement();
            writer.writeStartElement("routeId");
            writer.writeCharacters(restOperation.getRouteId());
            writer.writeEndElement();
            if (data.get("REST_PARAMS") != null) {
                writer.writeStartElement("request");
                writer.writeCData(jsonMarshaller.marshal(data.get("REST_PARAMS")));
                writer.writeEndElement();
            }
            if (data.get("REST_RESULT") != null) {
                writer.writeStartElement("response");
                writer.writeCData(jsonMarshaller.marshal(data.get("REST_RESULT")));
                writer.writeEndElement();
            }
            List validationMessages = ValidationHelper.getAllValidationMessages((Validatable)validatedParams).values().stream().flatMap(Collection::stream).filter(validationMessage -> TextUtil.nonBlank((String)validationMessage.getText())).collect(Collectors.toList());
            for (ValidationMessage validationMessage2 : validationMessages) {
                writer.writeStartElement("validationMessage");
                writer.writeCharacters(validationMessage2.getText());
                writer.writeEndElement();
            }
            if (error != null) {
                writer.writeStartElement("error");
                writer.writeCharacters(error);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        Document document = new Document();
        String docName = "LogExtApi" + ExtApiLoggerDocumentBuilder.getServicesFromURL(url);
        document.setTitle(docName);
        document.setName(docName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xml");
        document.setContentType(ContentType.XML);
        document.setCreated(new Date());
        document.setType(DocumentType.EXTAPI_LOG);
        if (container != null) {
            document.setOwner(container.toReference());
        }
        document.setContent(baos.toByteArray());
        EntityContainer docCtr = EntityContainer.create((BaseEntity)document);
        docCtr.getVersionInfo().setDataSource("ext-api");
        EntityStorage.get().save(docCtr, false);
    }

    public static String getServicesFromURL(String requestURL) {
        String[] requestURLSplit = requestURL.split("/");
        String services = "";
        if (requestURLSplit.length >= 5) {
            for (int i = 5; i < requestURLSplit.length; ++i) {
                services = services.concat("-" + requestURLSplit[i]);
            }
        }
        return services;
    }
}

