/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.logger;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.externalApi.extApiV2.ExtApiLoggingSettings;
import com.gridnine.xtrip.server.ibecorp.externalApi.logger.ExtApiLoggerDocumentBuilder;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptor;
import java.util.Map;

public class ExtApiLoggerInterceptor
implements GenericRestInterceptor {
    private static final String ERROR_KEY = ExtApiLoggerInterceptor.class.getName() + ".error";
    private static final String URL_PREFIX = "/extapi/v2/";

    public void before(RestContext context, Map<String, Object> data) throws Exception {
    }

    private static ExtApiLoggingSettings getSettings() {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(ExtApiLoggingSettings.class.getName());
        EntityContainer settingsCtr = EntityStorage.get().load(ExtApiLoggingSettings.class, settingsUid);
        if (settingsCtr == null) {
            settingsCtr = new EntityContainer(ExtApiLoggingSettings.class, settingsUid);
            ((ExtApiLoggingSettings)settingsCtr.getEntity()).setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f ExtApi");
            settingsCtr.getVersionInfo().setDataSource("ExtApiLoggerInterceptor");
            EntityStorage.get().save(settingsCtr, true);
        }
        return (ExtApiLoggingSettings)settingsCtr.getEntity();
    }

    private static boolean isEnabled(RestContext context) {
        ExtApiLoggingSettings settings = ExtApiLoggerInterceptor.getSettings();
        String url = context.getRequest().getRequestURL().toString();
        url = url.substring(url.indexOf(URL_PREFIX) + URL_PREFIX.length());
        return settings.getRequestUrls().contains(url);
    }

    public boolean handleException(RestContext context, Map<String, Object> data, Throwable exception) throws Exception {
        if (!ExtApiLoggerInterceptor.isEnabled(context)) {
            return false;
        }
        StackTraceElement[] stackTrace = exception.getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append(element.toString()).append("\n");
        }
        data.put(ERROR_KEY, exception.getLocalizedMessage() + '\n' + sb);
        return false;
    }

    public void after(RestContext context, Map<String, Object> data) throws Exception {
        if (!ExtApiLoggerInterceptor.isEnabled(context)) {
            return;
        }
        String url = context.getRequest().getRequestURL().toString();
        String error = (String)data.get(ERROR_KEY);
        ExtApiLoggerDocumentBuilder.BuildLogDocument(data, url, error);
    }
}

