/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.rules;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyActionsResult;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsResult;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpAirProductPropertySet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.TravelPolicyStatisticsHelper;
import com.gridnine.xtrip.server.ibecorp.handlers.travelPolicy.IbecorpTravelPolicyProductPropertySet;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyHelper;
import com.gridnine.xtrip.server.model.handlers.AirRulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySet;
import java.util.Date;

public class IbecorpAirRulesHandler
implements AirRulesProductHandler {
    public ProductPropertySet createPropertySet(RuleProxy<ProductPropertySet, ProductCommissionActionSet> proxy) {
        return new IbecorpAirProductPropertySet(proxy);
    }

    public void applyTravelPolicy(Product product, AirProductContractRelationData contractRelation, boolean traceEnabled) throws Exception {
        if (TravelPolicyAuthorizationHelper.isAuthorizationStarted((BaseProduct)product)) {
            return;
        }
        Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler((BaseProduct)product).findIssueDate((BaseProduct)product), Date::new);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!traceEnabled);
        proxy.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId());
        proxy.setProxyDate(date);
        IbecorpTravelPolicyProductPropertySet propSet = new IbecorpTravelPolicyProductPropertySet(proxy);
        proxy.setPropertySet((Object)propSet);
        propSet.init(product);
        proxy.setActionSet((Object)new IbecorpTravelPolicyActionsResult());
        TravelPolicyHelper.applyTravelPolicyRules((BaseProduct)product, (EntityReference<Contract>)contractRelation.getGeneralData().getContractData().getContract(), (RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>)proxy);
        TravelPolicyImpositionResult result = new TravelPolicyImpositionResult();
        product.setTravelPolicyImpositionResult(result);
        TravelPolicyHelper.setTravelPolicyResult((RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, ? extends IbecorpTravelPolicyActionsResult>)proxy, result);
        TravelPolicyStatisticsHelper.setTravelPolicyResult((RuleProxy<? extends TravelPolicyPropertiesProvider, ? extends TravelPolicyActionsResult>)proxy, (BaseProduct)product);
    }
}

