/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.rules;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.HotelPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class IbecorpHotelActionSet
extends HotelActionSet {
    public IbecorpHotelActionSet(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelPropertySet propertySet, HotelProduct item) {
        super(proxy, item, IbecorpHotelActionSet.createIbecorpHandler(IbecorpHotelActionSet.createHandler((HotelProduct)item, (HotelPropertiesProvider)propertySet, (Set)IbecorpHotelActionSet.getPaymentTypes((HotelProduct)item)), item, propertySet));
    }

    static GeneralProductCommissionActionSet.CommissionActionProxy createIbecorpHandler(final GeneralProductCommissionActionSet.CommissionActionProxy handler, final HotelProduct item, final HotelPropertySet propertySet) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            public boolean isOneWayTicket() {
                return handler.isOneWayTicket();
            }

            public boolean isForcedRefund() {
                return item.isForcedRefund() || item.getStatus() == ProductStatus.REJECT;
            }

            public List<ValidationMessage> getValidationMessages() {
                return handler.getValidationMessages();
            }

            public TicketType getTicketType() {
                return handler.getTicketType();
            }

            public String getTargetType() {
                return handler.getTargetType();
            }

            public ProductStatus getStatus() {
                ProductStatus status = item.getStatus();
                if (ProductStatus.REQUEST == status) {
                    return ProductStatus.BOOKING;
                }
                if (ProductStatus.REJECT == status) {
                    return ProductStatus.REFUND;
                }
                if (ProductStatus.INTENTION == status) {
                    return ProductStatus.BOOKING;
                }
                return status;
            }

            public int getSegmentsCount() {
                return handler.getSegmentsCount();
            }

            public int getSegmentTariffsCount() {
                return handler.getSegmentsCount();
            }

            public EntityReference<SalesPoint> getSalesPoint() {
                return handler.getSalesPoint();
            }

            public ProductType getProductType() {
                return handler.getProductType();
            }

            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                HotelProduct prevProduct = item.getPreviousProduct();
                if (prevProduct == null) {
                    return null;
                }
                GeneralProductCommissionActionSet.CommissionActionProxy proxy2 = HotelActionSet.createHandler((HotelProduct)prevProduct, (HotelPropertiesProvider)propertySet, (Set)HotelActionSet.getPaymentTypes((HotelProduct)prevProduct));
                return IbecorpHotelActionSet.createIbecorpHandler(proxy2, prevProduct, propertySet);
            }

            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                HotelProduct nextProduct = item.getNextProduct();
                if (nextProduct == null) {
                    return null;
                }
                GeneralProductCommissionActionSet.CommissionActionProxy proxy2 = HotelActionSet.createHandler((HotelProduct)nextProduct, (HotelPropertiesProvider)propertySet, (Set)HotelActionSet.getPaymentTypes((HotelProduct)nextProduct));
                return IbecorpHotelActionSet.createIbecorpHandler(proxy2, nextProduct, propertySet);
            }

            public boolean hasNextSellAfterRefund() {
                if (item.getStatus() != ProductStatus.REFUND) {
                    return false;
                }
                return item.getNextProduct() != null && item.getNextProduct().getStatus() == ProductStatus.SELL;
            }

            public Set<String> getPaymentTypes() {
                return handler.getPaymentTypes();
            }

            public Date getIssueDate() {
                return handler.getIssueDate();
            }

            public BigDecimal getAdditionalFare() {
                return null;
            }

            public int getTravellersCount() {
                return item.getTravellers().size();
            }
        };
    }
}

