/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.rules;

import com.gridnine.xtrip.common.ibecorp.rules.HotelTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTripartitePropertiesSetProvider;
import com.gridnine.xtrip.common.ibecorp.rules.SmSiteTypeProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpHotelPropertySetContext;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySetContext;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IbecorpHotelPropertySet
extends HotelPropertySet
implements IbecorpTripartitePropertiesSetProvider,
SmSiteTypeProvider,
HotelTravelPolicyPropertiesProvider {
    private boolean isTripartiteAgreement;
    private SMSiteType smSiteType;
    private final Set<EntityReference<Person>> persons = new HashSet<EntityReference<Person>>();
    private BigDecimal clientTotal;
    private String clientCurrency;
    private SMGeneralSettings smGeneralSettings;
    private TravelPolicyMatchType matchType;

    public IbecorpHotelPropertySet(RuleProxy<? extends HotelPropertySet, ?> aProxy) {
        super(aProxy);
    }

    public void init(HotelProduct product) {
        this.init(product, HotelRulesHelper.getHotelRulesHandler().createPropertySetContext(product));
    }

    public void init(HotelProduct product, HotelPropertySetContext context) {
        super.init(product, context);
        IbecorpHotelPropertySetContext ibeContext = (IbecorpHotelPropertySetContext)context;
        this.isTripartiteAgreement = product.isTripartiteAgreement();
        this.smSiteType = ibeContext.getSmSiteType();
        this.smGeneralSettings = ibeContext.getSmGeneralSettings();
        this.setClientTotal(product);
        this.setClientCurrency(product);
        ProductHandler.of((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.persons::add);
    }

    public boolean isTripartiteAgreement() {
        return this.isTripartiteAgreement;
    }

    public SMSiteType getSMSiteType() {
        return this.smSiteType;
    }

    public Set<EntityReference<Person>> getPersons() {
        return this.persons;
    }

    public BigDecimal getClientTotal() {
        return this.clientTotal;
    }

    public void setClientTotal(HotelProduct product) {
        this.clientTotal = BookingHelper.getTotalPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
    }

    public BigDecimal getMinimal(EntityReference<BaseTravelPolicyMinimalPriceProperties> propsRef) {
        throw new UnsupportedOperationException();
    }

    public String getClientCurrency() {
        return this.clientCurrency;
    }

    public void setClientCurrency(HotelProduct product) {
        DictionaryReference currency = GeneralProductHelper.getCurrency((BaseContractRelationData)GeneralProductHelper.getContractRelation((BaseProduct)product, (ContractType)ContractType.CLIENT));
        this.clientCurrency = DictHelper.getCode((DictionaryReference)currency);
    }

    public SMGeneralSettings getSmGeneralSettings() {
        return this.smGeneralSettings;
    }

    public void setMatchType(TravelPolicyMatchType matchType) {
        this.matchType = matchType;
    }

    public TravelPolicyMatchType getMatchType() {
        return this.matchType;
    }
}

