/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.rules;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyActionsResult;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyProductImpositionResults;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsResult;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.model.validation.XtripHotelsValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.function.CachingSupplier;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpHotelActionSet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpHotelPropertySet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpHotelPropertySetContext;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.TravelPolicyStatisticsHelper;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.results.IbecorpHotelProductImpositionResultsHandler;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyHelper;
import com.gridnine.xtrip.server.model.handlers.HotelActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.RulesCache;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class IbecorpHotelRulesHandler
extends HotelRulesHandler {
    public HotelActionSet createActionSet(RuleProxy<HotelPropertySet, HotelActionSet> proxy, HotelProduct item) {
        return new IbecorpHotelActionSet(proxy, (HotelPropertySet)proxy.getPropertySet(), item);
    }

    public HotelPropertySet createPropertySet(RuleProxy<HotelPropertySet, ?> proxy) {
        return new IbecorpHotelPropertySet(proxy);
    }

    public IbecorpHotelPropertySetContext createPropertySetContext(HotelProduct product) {
        return new IbecorpHotelPropertySetContext(product);
    }

    protected ProductStatus getProductStatus(HotelProduct product) {
        ProductStatus status = super.getProductStatus(product);
        if (ProductStatus.REQUEST == status) {
            return ProductStatus.BOOKING;
        }
        if (ProductStatus.REJECT == status) {
            return ProductStatus.REFUND;
        }
        if (ProductStatus.INTENTION == status) {
            return ProductStatus.BOOKING;
        }
        return status;
    }

    protected void afterCommissionCalculated(HotelProduct product) {
        super.afterCommissionCalculated(product);
        CachingSupplier localCurrency = new CachingSupplier(DictHelper::getLocalCurrency);
        HotelProductContractRelationData vendorContractRelation = HotelProductHelper.getVendorContractRelation((HotelProduct)product);
        if (vendorContractRelation != null) {
            for (GeneralProductCommission commission2 : vendorContractRelation.getCommissions()) {
                Money basePrice;
                if (!HotelProductHelper.isVendorCommissionProperties((EntityReference)commission2.getCommissionProperties())) continue;
                Money amount = null;
                if (commission2.getAmount() != null) {
                    amount = commission2.getAmount();
                } else if (commission2.getPercentage() != null && !product.getRooms().isEmpty() && (basePrice = ((Room)product.getRooms().get(0)).getBasePrice()) != null) {
                    amount = MoneyHelper.buildMoney((BigDecimal)basePrice.getValue().multiply(BigDecimal.valueOf(commission2.getPercentage())).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP), (String)basePrice.getCurrency());
                }
                if (null == amount || Objects.equals(MiscUtil.guarded((Object)amount.getCurrency(), (Supplier)localCurrency), MiscUtil.guarded(vendorContractRelation.getGeneralData().getCurrency() != null ? vendorContractRelation.getGeneralData().getCurrency().getCode() : null, (Supplier)localCurrency))) continue;
                commission2.setEquivalentAmount(MulticurrencyHelper.convert((BigDecimal)amount.getValue(), (ExchangeRateData)vendorContractRelation.getGeneralData().getRate()));
            }
            GeneralProductCommission vendorCommission = vendorContractRelation.getCommissions().stream().filter(commission -> HotelProductHelper.isVendorCommissionProperties((EntityReference)commission.getCommissionProperties())).findFirst().orElse(null);
            if (vendorCommission != null) {
                Collection commissions = GeneralProductHelper.filterCommissions((Collection)vendorContractRelation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null);
                ArrayList<GeneralProductCommission> commissionsToDelete = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission commission3 : commissions) {
                    if (vendorCommission.equals((Object)commission3)) continue;
                    if (!MiscUtil.equals((Object)vendorCommission.getEquivalentAmount(), (Object)commission3.getEquivalentAmount())) {
                        product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_VENDOR_COMMISSION_AMOUNT_DIFFERS, (Object[])new Object[]{vendorCommission.getEquivalentAmount(), commission3.getEquivalentAmount()}));
                    }
                    commissionsToDelete.add(commission3);
                }
                vendorContractRelation.getCommissions().removeIf(commissionsToDelete::contains);
            }
        }
    }

    protected void applyTravelPolicy(HotelProduct product, GeneralProductContractRelationData contractRelation, RulesCache<?> rulesCache, boolean traceEnabled) throws Exception {
        TravelPolicyProductImpositionResults productImpositionResults = IbecorpHotelProductImpositionResultsHandler.PRODUCT_IMPOSITION_RESULTS.get();
        if (TravelPolicyAuthorizationHelper.isAuthorizationStarted((BaseProduct)product)) {
            return;
        }
        Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler((BaseProduct)product).findIssueDate((BaseProduct)product), Date::new);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!traceEnabled);
        proxy.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId());
        proxy.setProxyDate(date);
        if (rulesCache != null && rulesCache.getPropertySet() != null) {
            proxy.setPropertySet((Object)((IbecorpHotelPropertySet)((Object)rulesCache.getPropertySet())));
            this.updatePropertySet((HotelPropertySet)proxy.getPropertySet(), product);
        } else {
            proxy.setPropertySet((Object)new IbecorpHotelPropertySet(proxy));
            ((IbecorpHotelPropertySet)((Object)proxy.getPropertySet())).init(product);
        }
        proxy.setActionSet((Object)new IbecorpTravelPolicyActionsResult());
        TravelPolicyHelper.applyTravelPolicyRules((BaseProduct)product, (EntityReference<Contract>)contractRelation.getGeneralData().getContractData().getContract(), (RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>)proxy);
        TravelPolicyImpositionResult result = null;
        if (productImpositionResults != null) {
            result = (TravelPolicyImpositionResult)productImpositionResults.getProduct2Result().get(product);
        }
        if (null == result) {
            result = new TravelPolicyImpositionResult();
        }
        product.setTravelPolicyImpositionResult(result);
        TravelPolicyHelper.setTravelPolicyResult((RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, ? extends IbecorpTravelPolicyActionsResult>)proxy, result);
        TravelPolicyStatisticsHelper.setTravelPolicyResult((RuleProxy<? extends TravelPolicyPropertiesProvider, ? extends TravelPolicyActionsResult>)proxy, (BaseProduct)product);
    }

    private void updatePropertySet(HotelPropertySet propertySet, HotelProduct product) {
        IbecorpHotelPropertySet ibePropertySet = (IbecorpHotelPropertySet)propertySet;
        ibePropertySet.setClientCurrency(product);
        ibePropertySet.setClientTotal(product);
    }

    protected EntityReference<Contract> getDefaultContract(HotelProduct product, ContractType contractType) {
        return ContractType.VENDOR == contractType && product.getProvider() == HotelProvider.INTERNAL ? product.getVendorContract() : null;
    }
}

