/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.rules;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyActionsResult;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyProductImpositionResults;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsResult;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpRailwayProductCommissionActionSet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpRailwayProductPropertySet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.TravelPolicyStatisticsHelper;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.results.IbecorpRailwayProductImpositionResultsHandler;
import com.gridnine.xtrip.server.ibecorp.handlers.travelPolicy.IbecorpTravelPolicyRailwayProductPropertySet;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyHelper;
import com.gridnine.xtrip.server.railway.handlers.rules.RailwayRulesHandler;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductCommissionActionSet;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductPropertySet;
import java.util.Date;

public class IbecorpRailwayRulesProductHandler
extends RailwayRulesHandler.RailwayRulesProductHandler {
    public RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> createProxy(RailwayProduct item, boolean enabledTracer) {
        RuleProxy proxy = new RuleProxy();
        IbecorpRailwayProductPropertySet props = new IbecorpRailwayProductPropertySet(proxy);
        proxy.getTracer().setDisabled(!enabledTracer);
        proxy.setPropertySet((Object)props);
        proxy.setProxyDate(item.getIssueDate());
        proxy.setProxyType(Targets.RAILWAY_PRODUCT_COMMISSION.getId());
        ((RailwayProductPropertySet)proxy.getPropertySet()).init(item);
        return proxy;
    }

    public void applyTravelPolicy(RailwayProduct product, GeneralProductContractRelationData contractRelation, boolean traceEnabled) throws Exception {
        TravelPolicyProductImpositionResults productImpositionResults = IbecorpRailwayProductImpositionResultsHandler.PRODUCT_IMPOSITION_RESULTS.get();
        if (TravelPolicyAuthorizationHelper.isAuthorizationStarted((BaseProduct)product)) {
            return;
        }
        Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler((BaseProduct)product).findIssueDate((BaseProduct)product), Date::new);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!traceEnabled);
        proxy.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId());
        proxy.setProxyDate(date);
        proxy.setPropertySet((Object)new IbecorpTravelPolicyRailwayProductPropertySet(proxy));
        ((IbecorpTravelPolicyRailwayProductPropertySet)((Object)proxy.getPropertySet())).init(product);
        proxy.setActionSet((Object)new IbecorpTravelPolicyActionsResult());
        TravelPolicyHelper.applyTravelPolicyRules((BaseProduct)product, (EntityReference<Contract>)contractRelation.getGeneralData().getContractData().getContract(), (RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>)proxy);
        TravelPolicyImpositionResult result = null;
        if (productImpositionResults != null) {
            result = (TravelPolicyImpositionResult)productImpositionResults.getProduct2Result().get(product);
        }
        if (null == result) {
            result = new TravelPolicyImpositionResult();
        }
        product.setTravelPolicyImpositionResult(result);
        TravelPolicyHelper.setTravelPolicyResult((RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, ? extends IbecorpTravelPolicyActionsResult>)proxy, result);
        TravelPolicyStatisticsHelper.setTravelPolicyResult((RuleProxy<? extends TravelPolicyPropertiesProvider, ? extends TravelPolicyActionsResult>)proxy, (BaseProduct)product);
    }

    public void clearActionSet(RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> proxy, RailwayProduct item) {
        proxy.getAppliedRuleCategories().clear();
        proxy.getAppliedRules().clear();
        proxy.getTracer().clear();
        proxy.setActionSet((Object)new IbecorpRailwayProductCommissionActionSet(proxy, (RailwayProductPropertiesProvider)proxy.getPropertySet(), item));
    }
}

