/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.rules;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyActionsResult;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyProductImpositionResults;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsResult;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpTransferActionSet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpTransferPropertySet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.TravelPolicyStatisticsHelper;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.results.IbecorpTransferProductImpositionResultsHandler;
import com.gridnine.xtrip.server.ibecorp.handlers.travelPolicy.IbecorpTravelPolicyTransferPropertySet;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyHelper;
import com.gridnine.xtrip.server.model.handlers.TransferActionSet;
import com.gridnine.xtrip.server.model.handlers.TransferPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.TransferRulesHandler;
import java.util.Date;

public class IbecorpTransferRulesHandler
extends TransferRulesHandler.TransferRulesProductHandler {
    public RuleProxy<TransferPropertySet, TransferActionSet> createProxy(Transfer item, boolean enabledTracer) throws Exception {
        RuleProxy proxy = new RuleProxy();
        IbecorpTransferPropertySet props = new IbecorpTransferPropertySet(proxy);
        proxy.setPropertySet((Object)props);
        proxy.setProxyDate(item.getIssueDate());
        proxy.setProxyType(Targets.TRANSFER.getId());
        proxy.getTracer().setDisabled(!enabledTracer);
        ((TransferPropertySet)proxy.getPropertySet()).init(item);
        return proxy;
    }

    public TransferActionSet createActionSet(RuleProxy<TransferPropertySet, TransferActionSet> proxy, Transfer item) {
        return new IbecorpTransferActionSet(proxy, item);
    }

    public void applyTravelPolicy(Transfer product, GeneralProductContractRelationData contractRelation, boolean traceEnabled) throws Exception {
        if (TravelPolicyAuthorizationHelper.isAuthorizationStarted((BaseProduct)product)) {
            return;
        }
        TravelPolicyProductImpositionResults productImpositionResults = IbecorpTransferProductImpositionResultsHandler.PRODUCT_IMPOSITION_RESULTS.get();
        Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler((BaseProduct)product).findIssueDate((BaseProduct)product), Date::new);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!traceEnabled);
        proxy.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId());
        proxy.setProxyDate(date);
        proxy.setPropertySet((Object)new IbecorpTravelPolicyTransferPropertySet(proxy));
        ((IbecorpTravelPolicyTransferPropertySet)((Object)proxy.getPropertySet())).init(product);
        proxy.setActionSet((Object)new IbecorpTravelPolicyActionsResult());
        TravelPolicyHelper.applyTravelPolicyRules((BaseProduct)product, (EntityReference<Contract>)contractRelation.getGeneralData().getContractData().getContract(), (RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>)proxy);
        TravelPolicyImpositionResult result = null;
        if (productImpositionResults != null) {
            result = (TravelPolicyImpositionResult)productImpositionResults.getProduct2Result().get(product);
        }
        if (null == result) {
            result = new TravelPolicyImpositionResult();
        }
        product.setTravelPolicyImpositionResult(result);
        TravelPolicyHelper.setTravelPolicyResult((RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, ? extends IbecorpTravelPolicyActionsResult>)proxy, result);
        TravelPolicyStatisticsHelper.setTravelPolicyResult((RuleProxy<? extends TravelPolicyPropertiesProvider, ? extends TravelPolicyActionsResult>)proxy, (BaseProduct)product);
    }
}

