/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.rules;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TravelPolicyViolationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsResult;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class TravelPolicyStatisticsHelper {
    public static final Collection<CalculatedStatisticType> TRAVEL_POLICY_STATISTICS = Arrays.asList(CalculatedStatisticType.TRAVEL_POLICY_VIOLATION, CalculatedStatisticType.TRAVEL_POLICY_AUTHORIZATION, CalculatedStatisticType.TRAVEL_POLICY_REASON_CODE, CalculatedStatisticType.TRAVEL_POLICY_LIMIT, CalculatedStatisticType.TRAVEL_POLICY_SALES_DEEPS_LIMIT);

    private static Set<CalculatedStatisticType> getCalculatedStatisticSettings(BaseProduct product) {
        if (product.getReservation() == null || product.getReservation().getBookingFile() == null) {
            return null;
        }
        EntityContainer clientCtr = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (null == clientCtr) {
            return null;
        }
        return ((Organization)clientCtr.getEntity()).getCalculatedStatisticSettings();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasTravelPolicyStatistics(BaseProduct product) {
        Set<CalculatedStatisticType> settings = TravelPolicyStatisticsHelper.getCalculatedStatisticSettings(product);
        if (settings == null) return false;
        if (!TRAVEL_POLICY_STATISTICS.stream().anyMatch(settings::contains)) return false;
        return true;
    }

    public static void setTravelPolicyResult(RuleProxy<? extends TravelPolicyPropertiesProvider, ? extends TravelPolicyActionsResult> proxy, BaseProduct product) {
        Set<CalculatedStatisticType> settings = TravelPolicyStatisticsHelper.getCalculatedStatisticSettings(product);
        if (null == settings) {
            return;
        }
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        StatisticalData statisticalData = handler.getStatisticalData(product);
        if (null == statisticalData) {
            handler.newStatisticalData(product);
            statisticalData = handler.getStatisticalData(product);
        }
        statisticalData.setTravelPolicyApplied(true);
        TravelPolicyImpositionResult travelPolicyImpositionResult = (TravelPolicyImpositionResult)MiscUtil.guarded((Object)TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)product), (Object)new TravelPolicyImpositionResult());
        if (settings.contains(CalculatedStatisticType.TRAVEL_POLICY_VIOLATION)) {
            if (travelPolicyImpositionResult.getMatchType() != null) {
                switch (travelPolicyImpositionResult.getMatchType()) {
                    case VIOLATION: {
                        statisticalData.setTravelPolicyViolation(TravelPolicyViolationType.VIOLATION);
                        break;
                    }
                    case STRICT_VIOLATION: {
                        statisticalData.setTravelPolicyViolation(TravelPolicyViolationType.VIOLATION_STRICT);
                        break;
                    }
                    default: {
                        statisticalData.setTravelPolicyViolation(null);
                        break;
                    }
                }
            } else {
                statisticalData.setTravelPolicyViolation(null);
            }
        }
        if (settings.contains(CalculatedStatisticType.TRAVEL_POLICY_AUTHORIZATION)) {
            statisticalData.setTravelPolicyAuthorization(Boolean.valueOf(travelPolicyImpositionResult.getAuthorizationParameters() != null));
        }
        if (settings.contains(CalculatedStatisticType.TRAVEL_POLICY_REASON_CODE)) {
            statisticalData.setTravelPolicyReasonCode(Boolean.valueOf(travelPolicyImpositionResult.isReasonCodeRequired()));
        }
        TravelPolicyActionsResult actions = (TravelPolicyActionsResult)proxy.getActionSet();
        if (settings.contains(CalculatedStatisticType.TRAVEL_POLICY_LIMIT)) {
            statisticalData.setTravelPolicyLimit(actions.getPriceLimit());
        }
        if (settings.contains(CalculatedStatisticType.TRAVEL_POLICY_SALES_DEEPS_LIMIT)) {
            statisticalData.setTravelPolicySalesDeepsLimit(actions.getTimeLimit());
        }
    }
}

