/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.handlers.travelPolicy;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersExPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rules.SmSiteTypeProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.railway.model.rules.travelPolicy.TravelPolicyRailwayProductPropertySet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IbecorpTravelPolicyRailwayProductPropertySet
extends TravelPolicyRailwayProductPropertySet
implements IbecorpTravelPolicyPropertiesProvider,
RzdParametersExPropertiesProvider,
SmSiteTypeProvider {
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final List<String> trainTypes = new ArrayList<String>();
    private final List<String> serviceLists = new ArrayList<String>();
    private EntityReference<Person> agent;
    private EntityReference<? extends BaseGdsAccount> gdsAccount;
    private SMSiteType smSiteType;
    private SMGeneralSettings smGeneralSettings;

    public IbecorpTravelPolicyRailwayProductPropertySet(RuleProxy<? extends RailwayProductPropertiesProvider, ?> ruleProxy) {
        super(ruleProxy);
    }

    public void init(RailwayProduct product) {
        super.init(product);
        RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)product.getReservation().getSubagency());
        this.agent = product.getCashier();
        this.gdsAccount = product.getReservation().getGdsNameInfo().getOnlineGdsAccount();
        product.getSegments().forEach(s -> {
            if (!TextUtil.isBlank((String)s.getTrainTitle())) {
                this.trainTypes.add(s.getTrainTitle());
            }
            if (!TextUtil.isBlank((String)s.getBrand())) {
                this.trainTypes.add(s.getBrand());
            }
            if (s.getServiceList() != null) {
                this.serviceLists.add(s.getServiceList());
            }
        });
        this.smSiteType = IbecorpRulesHelper.getSiteType((BaseProduct)product);
        this.smGeneralSettings = CommonHelper.getGeneralSettings(IbecorpRulesHelper.getSiteRef((BaseProduct)product));
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public List<String> getTrainTypes() {
        return this.trainTypes;
    }

    public List<String> getServiceLists() {
        return this.serviceLists;
    }

    public boolean isExternalRefund() {
        return this.product.isExternalRufund();
    }

    protected Date getSegmentArrivalDate(RailwaySegment segment) {
        Date arrivalDate = segment.getArriveDate();
        if (arrivalDate == null) {
            arrivalDate = segment.getLocalArriveDate();
        }
        return arrivalDate;
    }

    protected Date getSegmentDepartureDate(RailwaySegment segment) {
        Date departureDate = segment.getDepartureDate();
        if (departureDate == null) {
            departureDate = segment.getLocalDepartureDate();
        }
        return departureDate;
    }

    public SMSiteType getSMSiteType() {
        return this.smSiteType;
    }

    public SMGeneralSettings getSmGeneralSettings() {
        return this.smGeneralSettings;
    }
}

