/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.helpers;

import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.ibecorp.rules.BookingContactActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.BookingContactPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.BookingExternalSystemsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.BookingExternalSystemsPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.BookingTravellersEditingActionsSet;
import com.gridnine.xtrip.common.ibecorp.rules.BookingTravellersEditingPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpShipmentActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationFinDocsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.PersonProfileValidationActionsSet;
import com.gridnine.xtrip.common.ibecorp.rules.PersonProfileValidationPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersProperties;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.SalesContextProperties;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourceOperations;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.NotificationSettingsActionsSet;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.NotificationSettingsPropertySet;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class IbecorpRulesHelper {
    public static Integer calcSearchDaysLimit(SalesContext salesContext, RzdAbstractSearchParameters params) throws Exception {
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdParametersProperties(params, salesContext, null, proxy));
        proxy.setActionSet((Object)new RzdParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return ((RzdParametersActions)proxy.getActionSet()).getSearchDaysLimit();
    }

    public static List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> getContractsForShipment(EntityContainer<Shipment> shipmentContainer) {
        ContractType contractType = ContractType.CLIENT;
        EntityContainer contractCtr = EntityStorage.get().resolve((EntityReference)((Shipment)shipmentContainer.getEntity()).getContract());
        if (contractCtr != null && ((Contract)contractCtr.getEntity()).getContractType() != null) {
            contractType = ((Contract)contractCtr.getEntity()).getContractType();
        }
        return ProfileHelper.getContracts(null, (EntityReference)((Shipment)shipmentContainer.getEntity()).getSupplier(), (EntityReference)((Shipment)shipmentContainer.getEntity()).getCustomer(), (ContractType)contractType, (Date)((Shipment)shipmentContainer.getEntity()).getDate(), (boolean)false);
    }

    public static IbecorpShipmentActionSet applyShipmentRules(EntityContainer<Shipment> shipmentContainer, List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> contracts, List<Message> messages) {
        RuleProxy shipmentProxy = new RuleProxy();
        ShipmentPropertySet propertySet = new ShipmentPropertySet(shipmentProxy);
        ShipmentHolder shipmentHolder = new ShipmentHolder();
        shipmentHolder.setShipment(shipmentContainer);
        shipmentHolder.getCategories().clear();
        shipmentHolder.getCategories().addAll(((Shipment)shipmentContainer.getEntity()).getCategories());
        propertySet.init(shipmentHolder);
        IbecorpShipmentActionSet shipmentActionSet = new IbecorpShipmentActionSet();
        shipmentProxy.setProxyType(Targets.SHIPMENT.getId());
        shipmentProxy.setProxyDate(((Shipment)shipmentContainer.getEntity()).getDate());
        shipmentProxy.setPropertySet((Object)propertySet);
        shipmentProxy.setActionSet((Object)shipmentActionSet);
        for (MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo> contract : contracts) {
            List rules = ProfileHelper.getRuleContainers((EntityContainer)((EntityContainer)contract.getFirst()), (Date)((Shipment)shipmentContainer.getEntity()).getDate());
            for (EntityContainer rule : rules) {
                try {
                    RuleEngine.applyRules(Collections.singletonList(shipmentProxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                }
                catch (Exception e) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ShipmentApplyRulesError, (Throwable)e, (Object[])new Object[]{((EntityContainer)contract.getFirst()).toReference(), shipmentContainer.toReference()}));
                }
            }
        }
        return shipmentActionSet;
    }

    public static SMSiteType getSiteType(BaseProduct bp) {
        return IbecorpRulesHelper.getSiteType(IbecorpRulesHelper.getSiteRef(bp));
    }

    public static EntityReference<SMSite> getSiteRef(BaseProduct bp) {
        if (bp.getReservation() == null || bp.getReservation().getBookingFile() == null) {
            return null;
        }
        return bp.getReservation().getBookingFile().getSite();
    }

    public static SMSiteType getSiteType(EntityReference<SMSite> siteRef) {
        EntityContainer siteCtr = EntityStorage.get().resolve(siteRef);
        return siteCtr == null ? null : ((SMSite)siteCtr.getEntity()).getSiteType();
    }

    public static SMSiteType getSiteType(Reservation res) {
        if (res.getBookingFile() == null) {
            return null;
        }
        EntityReference siteRef = res.getBookingFile().getSite();
        return IbecorpRulesHelper.getSiteType((EntityReference<SMSite>)siteRef);
    }

    public static boolean isGranted(IbeRestrictionEntityResources resource) {
        try {
            return AclHelper.isGranted(null, (String)resource.getId(), (String)ProfileHelper.getLogin(), (String)StandardAclResourceOperations.VIEW.getId(), Collections.emptyList());
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static PersonProfileValidationActionsSet getPersonProfileValidationActions(Person curUser, SalesContext salesContext) throws Exception {
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.ibecorp.rules.Targets.PERSON_PROFILE_VALIDATION.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new PersonProfileValidationPropertySet((Collection)curUser.getTypes()));
        proxy.setActionSet((Object)new PersonProfileValidationActionsSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (PersonProfileValidationActionsSet)proxy.getActionSet();
    }

    public static BookingTravellersEditingActionsSet getBookingTravellersEditingActionsSet(SalesContext salesContext, TravelSubject travelSubject) throws Exception {
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.ibecorp.rules.Targets.BOOKING_TRAVELLERS_EDITING.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new BookingTravellersEditingPropertySet(salesContext, travelSubject));
        proxy.setActionSet((Object)new BookingTravellersEditingActionsSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        if (ProfileHelper.isRetailProfile((EntityReference)salesContext.getClient())) {
            ((BookingTravellersEditingActionsSet)proxy.getActionSet()).setForbidTravellerEditing(false);
        }
        return (BookingTravellersEditingActionsSet)proxy.getActionSet();
    }

    public static BookingExternalSystemsActionSet getBookingExternalSystemsActionSet(SalesContext salesContext) throws Exception {
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.ibecorp.rules.Targets.BOOKING_EXTERNAL_SYSTEMS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new BookingExternalSystemsPropertySet(salesContext));
        proxy.setActionSet((Object)new BookingExternalSystemsActionSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (BookingExternalSystemsActionSet)proxy.getActionSet();
    }

    public static BookingContactActionSet getBookingContactActionSet(PersonType curUserPersonType, SalesContext salesContext) throws Exception {
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.ibecorp.rules.Targets.BOOKING_CONTACT_SETTINGS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new BookingContactPropertySet(salesContext, curUserPersonType));
        proxy.setActionSet((Object)new BookingContactActionSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (BookingContactActionSet)proxy.getActionSet();
    }

    private static EntityContainer<Contract> getClientContractCtr(Reservation reservation) {
        BaseProduct product = (BaseProduct)reservation.getProducts().get(0);
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        if (contractRelation == null) {
            return null;
        }
        EntityReference contractRef = contractRelation.getGeneralData().getContractData().getContract();
        return EntityStorage.get().resolve(contractRef);
    }

    private static void applyClientContractRules(Reservation reservation, RuleProxy<?, ?> proxy) throws Exception {
        EntityContainer<Contract> contractCtr = IbecorpRulesHelper.getClientContractCtr(reservation);
        if (contractCtr == null) {
            throw Xeption.forEndUser((String)"NotificationFailed_NoClientContractInProduct", (Object[])new Object[0]);
        }
        List rules = ProfileHelper.getRuleContainers(contractCtr, (Date)proxy.getProxyDate(), Collections.singleton(proxy.getProxyType()));
        for (EntityContainer rule : rules) {
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
        }
    }

    public static NotificationFinDocsActionSet getNotificationFinDocsActionSet(Reservation reservation) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.ibecorp.rules.Targets.NOTIFICATION_EXTERNAL_FINDOCS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new SalesContextProperties(reservation.getBookingFile()));
        proxy.setActionSet((Object)new NotificationFinDocsActionSet());
        IbecorpRulesHelper.applyClientContractRules(reservation, proxy);
        return (NotificationFinDocsActionSet)proxy.getActionSet();
    }

    public static NotificationsActionSet getNotificationActionSet(Reservation reservation) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.ibecorp.rules.Targets.NOTIFICATION_TEMPLATE_EXTERNAL_FINDOCS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new NotificationsPropertySet());
        proxy.setActionSet((Object)new NotificationsActionSet());
        IbecorpRulesHelper.applyClientContractRules(reservation, proxy);
        return (NotificationsActionSet)proxy.getActionSet();
    }

    public static Set<NotificationRecipientType> getDisabledNotificationRecipientTypes(NotificationType notificationType, NotificationParameters notificationParameters) throws Exception {
        RuleSet rules = SalesContextHandler.get().getRules(notificationParameters.getSalesContext());
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.ibecorp.rules.Targets.NOTIFICATION_SETTINGS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new NotificationSettingsPropertySet(notificationType, notificationParameters));
        proxy.setActionSet((Object)new NotificationSettingsActionsSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return ((NotificationSettingsActionsSet)proxy.getActionSet()).getDisabledRecipientTypes();
    }
}

