/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bus.rules.BusFilteringCategories;
import com.gridnine.xtrip.common.fiscal.model.FiscalSettings;
import com.gridnine.xtrip.common.gds.model.CommonAirlineSettings;
import com.gridnine.xtrip.common.gds.rules.FilteringCategories;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineFilteringCategories;
import com.gridnine.xtrip.common.hotels2.rules.HotelsFilteringCategories;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.CorrespondenceFilteringCategories;
import com.gridnine.xtrip.common.ibecorp.gds.model.OrganizationAirlineSettings;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpFilteringCategories;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.midoffice.model.ComplementBookingSettings;
import com.gridnine.xtrip.common.model.booking.EMDCategorySettings;
import com.gridnine.xtrip.common.model.booking.NomenclatureSettings;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductSettings;
import com.gridnine.xtrip.common.model.forOfPayment.OrganizationFOPCheckRules;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.qualityCheck.OrganizationQualityCheckRules;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettings;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalFilteringCategories;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationFilteringCategories;
import com.gridnine.xtrip.common.model.rules.passport.PassportFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.MidofficeFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.emd.EMDCategoryFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomeclatureFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckFilteringCategories;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyFilteringCategories;
import com.gridnine.xtrip.common.model.rules.tripartite.TripartiteContractFilteringCategories;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicy;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.transfers.rules.TransferFilteringCategories;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;

public class RuleBinder {
    static final String PROPERTY = "(property) - ";
    static final String ACTION = "(action) - ";
    static final String TARGET = "(target) - ";
    static final RulesEnvironment re = RulesEnvironment.get();
    static final Map<RuleProperty, Set<RuleFilteringCategory>> propertyFilters = new HashMap<RuleProperty, Set<RuleFilteringCategory>>();
    static final Map<RuleAction, Set<RuleFilteringCategory>> actionFilters = new HashMap<RuleAction, Set<RuleFilteringCategory>>();
    static final Map<RuleTarget, Set<RuleFilteringCategory>> targetFilters = new HashMap<RuleTarget, Set<RuleFilteringCategory>>();
    static final Map<RuleProperty, Set<RuleTarget>> propertyTargets = new HashMap<RuleProperty, Set<RuleTarget>>();
    static final Map<RuleAction, Set<RuleTarget>> actionTargets = new HashMap<RuleAction, Set<RuleTarget>>();
    static final Map<RuleFilteringCategory, Set<String>> filteringCategoryObjects = new HashMap<RuleFilteringCategory, Set<String>>();
    static final List<RuleFilteringCategory> filteringCategories = new ArrayList<RuleFilteringCategory>();
    static final Locale loc = LocaleManager.get().getCurrentLocale();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> process() {
        LocaleManager.get().setCurrentLocale(Locale.ENGLISH);
        try {
            RuleBinder.fill();
            StringBuilder sbpf = new StringBuilder();
            sbpf.append("Property,Condition(s),");
            sbpf.append(filteringCategories.stream().map(fc -> StringEscapeUtils.escapeCsv((String)(fc.getDisplayName() + " (" + fc.getId() + ")"))).collect(Collectors.joining(",")));
            sbpf.append("\n");
            propertyFilters.keySet().stream().sorted(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")")).forEach(key -> {
                sbpf.append(StringEscapeUtils.escapeCsv((String)(key.getDisplayName() == null ? key.getId() : key.getDisplayName() + " (" + key.getId() + ")")));
                sbpf.append(",");
                sbpf.append(StringEscapeUtils.escapeCsv((String)re.getConditions(key).stream().map(RuleCondition::getDisplayName).sorted().collect(Collectors.joining(", "))));
                filteringCategories.forEach(fc -> {
                    if (propertyFilters.get(key).contains(fc)) {
                        sbpf.append('+');
                    }
                    sbpf.append(',');
                });
                sbpf.append("\n");
            });
            StringBuilder sbaf = new StringBuilder();
            sbaf.append("Action,");
            sbaf.append(filteringCategories.stream().map(fc -> StringEscapeUtils.escapeCsv((String)(fc.getDisplayName() + " (" + fc.getId() + ")"))).collect(Collectors.joining(",")));
            sbaf.append("\n");
            actionFilters.keySet().stream().sorted(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")")).forEach(key -> {
                sbaf.append(StringEscapeUtils.escapeCsv((String)(key.getDisplayName() == null ? key.getId() : key.getDisplayName() + " (" + key.getId() + ")")));
                sbaf.append(",");
                filteringCategories.forEach(fc -> {
                    if (actionFilters.get(key).contains(fc)) {
                        sbaf.append('+');
                    }
                    sbaf.append(',');
                });
                sbaf.append("\n");
            });
            StringBuilder sbtf = new StringBuilder();
            sbtf.append("Target,");
            sbtf.append(filteringCategories.stream().map(fc -> StringEscapeUtils.escapeCsv((String)(fc.getDisplayName() + " (" + fc.getId() + ")"))).collect(Collectors.joining(",")));
            sbtf.append("\n");
            targetFilters.keySet().stream().sorted(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")")).forEach(key -> {
                sbtf.append(StringEscapeUtils.escapeCsv((String)(key.getDisplayName() == null ? key.getId() : key.getDisplayName() + " (" + key.getId() + ")")));
                sbtf.append(",");
                filteringCategories.forEach(fc -> {
                    if (targetFilters.get(key).contains(fc)) {
                        sbtf.append('+');
                    }
                    sbtf.append(',');
                });
                sbtf.append("\n");
            });
            Set ts = re.getFilteringCategories().stream().flatMap(fc -> re.getTargets(fc).stream()).collect(Collectors.toCollection(() -> new TreeSet<RuleTarget>(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")"))));
            StringBuilder sbpt = new StringBuilder();
            sbpt.append("Property,Condition(s),");
            sbpt.append(ts.stream().map(t -> StringEscapeUtils.escapeCsv((String)(t.getDisplayName() + " (" + t.getId() + ")"))).collect(Collectors.joining(",")));
            sbpt.append("\n");
            propertyTargets.keySet().stream().sorted(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")")).forEach(key -> {
                sbpt.append(StringEscapeUtils.escapeCsv((String)(key.getDisplayName() == null ? key.getId() : key.getDisplayName() + " (" + key.getId() + ")")));
                sbpt.append(",");
                sbpt.append(StringEscapeUtils.escapeCsv((String)re.getConditions(key).stream().map(RuleCondition::getDisplayName).sorted().collect(Collectors.joining(", "))));
                ts.forEach(t -> {
                    if (propertyTargets.get(key).contains(t)) {
                        sbpt.append('+');
                    }
                    sbpt.append(',');
                });
                sbpt.append("\n");
            });
            StringBuilder sbat = new StringBuilder();
            sbat.append("Action,");
            sbat.append(ts.stream().map(t -> StringEscapeUtils.escapeCsv((String)(t.getDisplayName() + " (" + t.getId() + ")"))).collect(Collectors.joining(",")));
            sbat.append("\n");
            actionTargets.keySet().stream().sorted(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")")).forEach(key -> {
                sbat.append(StringEscapeUtils.escapeCsv((String)(key.getDisplayName() == null ? key.getId() : key.getDisplayName() + " (" + key.getId() + ")")));
                sbat.append(",");
                filteringCategories.forEach(t -> {
                    if (actionTargets.get(key).contains(t)) {
                        sbat.append('+');
                    }
                    sbat.append(',');
                });
                sbat.append("\n");
            });
            Set os = filteringCategoryObjects.values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toSet());
            StringBuilder sbfo = new StringBuilder();
            sbfo.append("Filtering Category,");
            sbfo.append(String.join((CharSequence)",", os));
            sbfo.append("\n");
            filteringCategoryObjects.keySet().stream().sorted(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")")).forEach(key -> {
                sbfo.append(StringEscapeUtils.escapeCsv((String)(key.getDisplayName() == null ? key.getId() : key.getDisplayName() + " (" + key.getId() + ")")));
                sbfo.append(",");
                os.forEach(t -> {
                    if (filteringCategoryObjects.get(key).contains(t)) {
                        sbfo.append('+');
                    }
                    sbfo.append(',');
                });
                sbfo.append("\n");
            });
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("propertyToFilteringCategory.txt", sbpf.toString());
            result.put("actionToFilteringCategory.txt", sbaf.toString());
            result.put("targetToFilteringCategory.txt", sbtf.toString());
            result.put("propertyToTarget.txt", sbpt.toString());
            result.put("actionToTarget.txt", sbat.toString());
            result.put("filteringCategoryToObject.txt", sbfo.toString());
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            Map<String, String> map = null;
            return map;
        }
        finally {
            LocaleManager.get().setCurrentLocale(loc);
        }
    }

    public static String process(String name) {
        if (name.startsWith(PROPERTY)) {
            return RuleBinder.processProperty(name.substring(PROPERTY.length()));
        }
        if (name.startsWith(ACTION)) {
            return RuleBinder.processAction(name.substring(ACTION.length()));
        }
        if (name.startsWith(TARGET)) {
            return RuleBinder.processTarget(name.substring(TARGET.length()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processProperty(String property) {
        if (TextUtil.isBlank((String)property)) {
            return "Specify the property!";
        }
        LocaleManager.get().setCurrentLocale(Locale.ENGLISH);
        try {
            RuleBinder.fill();
            StringBuilder sbp = new StringBuilder();
            sbp.append("Conditions,Filtering Categories,Targets");
            sbp.append("\n");
            RuleProperty p = propertyTargets.keySet().stream().filter(i -> property.equals(i.getDisplayName() + " (" + i.getId() + ")")).findFirst().orElse(null);
            if (p == null) {
                String string = "Failed to find property";
                return string;
            }
            Set cs = re.getConditions(p).stream().map(c -> StringEscapeUtils.escapeCsv((String)c.getDisplayName())).collect(Collectors.toCollection(TreeSet::new));
            Set fcs = propertyFilters.get(p) == null ? Collections.emptySet() : (Set)propertyFilters.get(p).stream().map(fc -> StringEscapeUtils.escapeCsv((String)(fc.getDisplayName() + " (" + fc.getId() + ")"))).collect(Collectors.toCollection(TreeSet::new));
            Set ts = propertyTargets.get(p).stream().map(t -> StringEscapeUtils.escapeCsv((String)(t.getDisplayName() + " (" + t.getId() + ")"))).collect(Collectors.toCollection(TreeSet::new));
            Iterator ci = cs.iterator();
            Iterator fci = fcs.iterator();
            Iterator ti = ts.iterator();
            while (ci.hasNext() || fci.hasNext() || ti.hasNext()) {
                if (ci.hasNext()) {
                    sbp.append((String)ci.next());
                }
                sbp.append(",");
                if (fci.hasNext()) {
                    sbp.append((String)fci.next());
                }
                sbp.append(",");
                if (ti.hasNext()) {
                    sbp.append((String)ti.next());
                }
                sbp.append("\n");
            }
            String string = sbp.toString();
            return string;
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String string = writer.toString();
            return string;
        }
        finally {
            LocaleManager.get().setCurrentLocale(loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processAction(String action) {
        if (TextUtil.isBlank((String)action)) {
            return "Specify the action!";
        }
        LocaleManager.get().setCurrentLocale(Locale.ENGLISH);
        try {
            RuleBinder.fill();
            StringBuilder sba = new StringBuilder();
            sba.append("Filtering Categories,Targets");
            sba.append("\n");
            RuleAction a = actionTargets.keySet().stream().filter(i -> action.equals(i.getDisplayName() + " (" + i.getId() + ")")).findFirst().orElse(null);
            if (a == null) {
                String string = "Failed to find action";
                return string;
            }
            Set fcs = actionFilters.get(a) == null ? Collections.emptySet() : (Set)actionFilters.get(a).stream().map(fc -> StringEscapeUtils.escapeCsv((String)(fc.getDisplayName() + " (" + fc.getId() + ")"))).collect(Collectors.toCollection(TreeSet::new));
            Set ts = actionTargets.get(a).stream().map(t -> StringEscapeUtils.escapeCsv((String)(t.getDisplayName() + " (" + t.getId() + ")"))).collect(Collectors.toCollection(TreeSet::new));
            Iterator fci = fcs.iterator();
            Iterator ti = ts.iterator();
            while (fci.hasNext() || ti.hasNext()) {
                if (fci.hasNext()) {
                    sba.append((String)fci.next());
                }
                sba.append(",");
                if (ti.hasNext()) {
                    sba.append((String)ti.next());
                }
                sba.append("\n");
            }
            String string = sba.toString();
            return string;
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String string = writer.toString();
            return string;
        }
        finally {
            LocaleManager.get().setCurrentLocale(loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processTarget(String target) {
        if (TextUtil.isBlank((String)target)) {
            return "Specify the target!";
        }
        LocaleManager.get().setCurrentLocale(Locale.ENGLISH);
        try {
            RuleBinder.fill();
            StringBuilder sbt = new StringBuilder();
            sbt.append("Filtering Categories");
            sbt.append("\n");
            RuleTarget t = targetFilters.keySet().stream().filter(i -> target.equals(i.getDisplayName() + " (" + i.getId() + ")")).findFirst().orElse(null);
            if (t == null) {
                String string = "Failed to find target";
                return string;
            }
            Set fcs = targetFilters.get(t) == null ? Collections.emptySet() : (Set)targetFilters.get(t).stream().map(fc -> StringEscapeUtils.escapeCsv((String)(fc.getDisplayName() + " (" + fc.getId() + ")"))).collect(Collectors.toCollection(TreeSet::new));
            for (String fc2 : fcs) {
                sbt.append(fc2);
                sbt.append("\n");
            }
            String string = sbt.toString();
            return string;
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String string = writer.toString();
            return string;
        }
        finally {
            LocaleManager.get().setCurrentLocale(loc);
        }
    }

    public static List<String> getList() {
        LocaleManager.get().setCurrentLocale(Locale.ENGLISH);
        RuleBinder.fill();
        List result = propertyTargets.keySet().stream().map(k -> PROPERTY + (k.getDisplayName() == null ? k.getId() : k.getDisplayName() + " (" + k.getId() + ")")).collect(Collectors.toList());
        result.addAll(actionTargets.keySet().stream().map(k -> ACTION + (k.getDisplayName() == null ? k.getId() : k.getDisplayName() + " (" + k.getId() + ")")).collect(Collectors.toList()));
        result.addAll(targetFilters.keySet().stream().map(k -> TARGET + (k.getDisplayName() == null ? k.getId() : k.getDisplayName() + " (" + k.getId() + ")")).collect(Collectors.toList()));
        LocaleManager.get().setCurrentLocale(loc);
        return result.stream().sorted().collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private static void fill() {
        void var2_21;
        void var2_18;
        Set os;
        void var2_13;
        void var2_11;
        propertyFilters.clear();
        actionFilters.clear();
        targetFilters.clear();
        propertyTargets.clear();
        actionTargets.clear();
        filteringCategoryObjects.clear();
        filteringCategories.clear();
        re.getFilteringCategories().forEach(fc -> {
            re.getProperties(fc).forEach(p -> {
                Set fcs = propertyFilters.computeIfAbsent((RuleProperty)p, n -> new HashSet());
                fcs.add(fc);
            });
            re.getActions(fc).forEach(a -> {
                Set fcs = actionFilters.computeIfAbsent((RuleAction)a, n -> new HashSet());
                fcs.add(fc);
            });
            re.getTargets(fc).forEach(t -> {
                Set fcs = targetFilters.computeIfAbsent((RuleTarget)t, n -> new HashSet());
                fcs.add(fc);
                re.getProperties(t).forEach(p -> {
                    Set ts = propertyTargets.computeIfAbsent((RuleProperty)p, n -> new HashSet());
                    ts.add(t);
                });
                re.getActions(t).forEach(a -> {
                    Set ts = actionTargets.computeIfAbsent((RuleAction)a, n -> new HashSet());
                    ts.add(t);
                });
            });
        });
        filteringCategories.addAll(re.getFilteringCategories());
        filteringCategories.sort(Comparator.comparing(i -> i.getDisplayName() == null ? i.getId() : i.getDisplayName() + " (" + i.getId() + ")"));
        Set os3 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)RulesMigrationFilteringCategories.RULES_MIGRATION, n -> new HashSet());
        os3.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(RulesMigrationSettings.class.getName())).getDisplayName());
        Object os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(OrganizationTravelPolicy.class.getName())).getDisplayName());
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY_AUTHORIZATION, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(OrganizationTravelPolicy.class.getName())).getDisplayName());
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)HotelProductSettingsFilteringCategories.HOTEL_PRODUCT_SETTINGS, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(HotelProductSettings.class.getName())).getDisplayName());
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)EMDCategoryFilteringCategories.EMD_CATEGORIES, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(EMDCategorySettings.class.getName())).getDisplayName());
        os2 = QualityCheckFilteringCategories.values();
        int n2 = ((QualityCheckFilteringCategories[])os2).length;
        boolean bl = false;
        while (var2_11 < n2) {
            QualityCheckFilteringCategories qualityCheckFilteringCategories = os2[var2_11];
            Set os22 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)qualityCheckFilteringCategories, n -> new HashSet());
            os22.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(OrganizationQualityCheckRules.class.getName())).getDisplayName());
            ++var2_11;
        }
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)NomeclatureFilteringCategories.NOMENCLATURE, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(NomenclatureSettings.class.getName())).getDisplayName());
        os2 = FOPFilteringCategories.values();
        int n3 = ((Object)os2).length;
        boolean bl2 = false;
        while (var2_13 < n3) {
            Object object = os2[var2_13];
            os = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)object, n -> new HashSet());
            os.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(OrganizationFOPCheckRules.class.getName())).getDisplayName());
            ++var2_13;
        }
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)FiscalFilteringCategories.FISCAL_RECEIPT, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(FiscalSettings.class.getName())).getDisplayName());
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)MidofficeFilteringCategories.COMPLEMENT_BOOKING, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(ComplementBookingSettings.class.getName())).getDisplayName());
        ArrayList<Object> rfcList = new ArrayList<Object>();
        rfcList.addAll(Arrays.asList(FilteringCategories.values()));
        rfcList.addAll(Arrays.asList(com.gridnine.xtrip.common.pg.rules.FilteringCategories.values()));
        rfcList.addAll(Arrays.asList(PassportFilteringCategories.values()));
        rfcList.addAll(Arrays.asList(IbecorpFilteringCategories.values()));
        rfcList.addAll(Arrays.asList(HotelsFilteringCategories.values()));
        rfcList.addAll(Arrays.asList(TransferFilteringCategories.values()));
        rfcList.retainAll(RulesEnvironment.get().getFilteringCategories());
        rfcList.removeAll(Arrays.asList(FilteringCategories.SEARCH_PCC_SETTINGS, FilteringCategories.ADDITIONAL_PARAMETERS, TravelPolicyFilteringCategories.TRAVEL_POLICY, TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY, TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY_AUTHORIZATION, IbecorpFilteringCategories.HOTEL_PREPROCESSING, IbecorpFilteringCategories.NOTIFICATION_EXTERNAL_FINDOCS, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_ISSUE, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_SITE, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_BALANCE));
        for (RuleFilteringCategory ruleFilteringCategory : rfcList) {
            Set set = filteringCategoryObjects.computeIfAbsent(ruleFilteringCategory, n -> new HashSet());
            set.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(SMSite.class.getName())).getDisplayName());
        }
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_ISSUE, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(NotificationSettings.class.getName())).getDisplayName());
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_SITE, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(NotificationSettings.class.getName())).getDisplayName());
        os2 = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_BALANCE, n -> new HashSet());
        os2.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(NotificationSettings.class.getName())).getDisplayName());
        for (RuleFilteringCategory ruleFilteringCategory : Arrays.asList(ContractsFilteringCategories.MODEL_CONTRACT, TravelPolicyFilteringCategories.TRAVEL_POLICY, CorrespondenceFilteringCategories.NOTIFICATION_FILTERING_CATEGORY, IbecorpFilteringCategories.HOTEL_PREPROCESSING, IbecorpFilteringCategories.NOTIFICATION_EXTERNAL_FINDOCS, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE)) {
            Set set = filteringCategoryObjects.computeIfAbsent(ruleFilteringCategory, n -> new HashSet());
            set.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(ModelContract.class.getName())).getDisplayName());
        }
        CommonAirlineFilteringCategories[] categories = new ArrayList(Arrays.asList(CommonAirlineFilteringCategories.values()));
        categories.remove(CommonAirlineFilteringCategories.COMMON_SEARCH_RESULT_FILTERING);
        for (CommonAirlineFilteringCategories commonAirlineFilteringCategories : categories) {
            Set set = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)commonAirlineFilteringCategories, n -> new HashSet());
            set.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(OrganizationAirlineSettings.class.getName())).getDisplayName());
        }
        categories = CommonAirlineFilteringCategories.values();
        int n4 = categories.length;
        boolean bl3 = false;
        while (var2_18 < n4) {
            CommonAirlineFilteringCategories commonAirlineFilteringCategories = categories[var2_18];
            os = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)commonAirlineFilteringCategories, n -> new HashSet());
            os.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(CommonAirlineSettings.class.getName())).getDisplayName());
            ++var2_18;
        }
        rfcList = new ArrayList();
        rfcList.addAll(Arrays.asList(FilteringCategories.values()));
        rfcList.addAll(Arrays.asList(com.gridnine.xtrip.common.pg.rules.FilteringCategories.values()));
        rfcList.addAll(Arrays.asList(BusFilteringCategories.values()));
        for (RuleFilteringCategory ruleFilteringCategory : rfcList) {
            Set set = filteringCategoryObjects.computeIfAbsent(ruleFilteringCategory, n -> new HashSet());
            set.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(SalesPoint.class.getName())).getDisplayName());
        }
        TripartiteContractFilteringCategories[] tripartiteContractFilteringCategoriesArray = TripartiteContractFilteringCategories.values();
        int n5 = tripartiteContractFilteringCategoriesArray.length;
        boolean bl4 = false;
        while (var2_21 < n5) {
            TripartiteContractFilteringCategories tripartiteContractFilteringCategories = tripartiteContractFilteringCategoriesArray[var2_21];
            os = filteringCategoryObjects.computeIfAbsent((RuleFilteringCategory)tripartiteContractFilteringCategories, n -> new HashSet());
            os.add(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(TripartiteContract.class.getName())).getDisplayName());
            ++var2_21;
        }
    }
}

