/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ShipmentRegistryHelper {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy");
    private static final String NO_VALUE = null;
    private static final Locale LOCALE_RU = new Locale("ru");
    private static final Locale LOCALE_EN = new Locale("en");
    private static final Locale LOCALE_BLANK = new Locale("");

    public static byte[] addMidofficeDataToExcel(byte[] originalExcel, Shipment shipment) throws Exception {
        XSSFWorkbook wb;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(originalExcel);){
            wb = new XSSFWorkbook((InputStream)bais);
        }
        XSSFSheet s = wb.createSheet("MOM");
        int rn = 0;
        rn = ShipmentRegistryHelper.addRows(s, rn++, "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f", (EntityReference<Organization>)shipment.getSupplier());
        rn = ShipmentRegistryHelper.addRows(s, rn++, "\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442", (EntityReference<Organization>)shipment.getCustomer());
        Optional<Contract> contract = Optional.ofNullable(shipment.getContract()).map(ref -> ref).map(EntityStorageHelper::resolve).map(EntityContainer::getEntity);
        ShipmentRegistryHelper.addRow(s, rn++, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440", "\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contract.map(Contract::getNumber).orElse(NO_VALUE));
        int n = rn++;
        ShipmentRegistryHelper.addRow(s, n, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440", "\u0414\u0430\u0442\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contract.map(Contract::getIssueDate).map(arg_0 -> ((FastDateFormat)DF).format(arg_0)).orElse(NO_VALUE));
        int n2 = rn++;
        ShipmentRegistryHelper.addRow(s, n2, "\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f", "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", Optional.ofNullable(shipment.getPeriodBegin()).map(arg_0 -> ((FastDateFormat)DF).format(arg_0)).orElse(NO_VALUE));
        int n3 = rn++;
        ShipmentRegistryHelper.addRow(s, n3, "\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f", "\u041a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430", Optional.ofNullable(shipment.getPeriodEnd()).map(arg_0 -> ((FastDateFormat)DF).format(arg_0)).orElse(NO_VALUE));
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            wb.write((OutputStream)baos);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static int addRows(XSSFSheet s, int rn, String object, EntityReference<Organization> orgRef) {
        Optional<Organization> org = Optional.ofNullable(EntityStorage.get().resolve(orgRef)).map(EntityContainer::getEntity);
        int n = rn++;
        ShipmentRegistryHelper.addRow(s, n, object, "\u042e\u0440. \u0444\u043e\u0440\u043c\u0430", org.map(Organization::getLegalForm).map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).map(BaseDictionary::getTranslations).map(ShipmentRegistryHelper::getValue).orElse(NO_VALUE));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u041a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", org.map(Organization::getShortName).map(L10nString::getValues).map(ShipmentRegistryHelper::getValue).orElse(NO_VALUE));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u041f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", org.map(Organization::getFullName).map(L10nString::getValues).map(ShipmentRegistryHelper::getValue).orElse(NO_VALUE));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u0418\u041d\u041d", org.map(Organization::getRegistrationId).orElse(NO_VALUE));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u041a\u041f\u041f", org.map(Organization::getKpp).orElse(NO_VALUE));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441", ShipmentRegistryHelper.buildAddress(org, AddressType.LEGAL));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441", ShipmentRegistryHelper.buildAddress(org, AddressType.FACTUAL));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u0410\u0434\u0440\u0435\u0441 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438", ShipmentRegistryHelper.buildAddress(org, AddressType.DELIVERY));
        ShipmentRegistryHelper.addRow(s, rn++, object, "\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d", ShipmentRegistryHelper.buildPhone(org, CommunicationType.WORK_PHONE));
        return rn;
    }

    private static String buildAddress(Optional<Organization> org, AddressType addressType) {
        Optional optAddress = org.map(ProfileHelper::getOrganizationAddresses).map(Collection::stream).flatMap(st -> st.filter(a -> a.getAddressType() == addressType).findFirst());
        if (!optAddress.isPresent()) {
            return NO_VALUE;
        }
        Address address = (Address)optAddress.get();
        return ProfileHelper.buildFullAddress((Address)address, (Locale)LOCALE_RU, (boolean)false);
    }

    private static String buildPhone(Optional<Organization> org, CommunicationType phoneType) {
        Optional optComm = org.map(Organization::getCommunications).map(Collection::stream).flatMap(st -> st.filter(a -> a.getType() == phoneType).findFirst());
        if (!optComm.isPresent()) {
            return NO_VALUE;
        }
        Communication comm = (Communication)optComm.get();
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        sb.append(comm.getCountryCode());
        sb.append("(");
        sb.append(comm.getCityCode());
        sb.append(")");
        sb.append(comm.getSense());
        if (!StringUtils.isBlank((String)comm.getInternalNumber())) {
            sb.append("#");
            sb.append(comm.getInternalNumber());
        }
        return sb.toString();
    }

    private static String getValue(Map<Locale, String> values) {
        String value = values.get(LOCALE_RU);
        if (value != null) {
            return value;
        }
        value = values.get(LOCALE_EN);
        if (value != null) {
            return value;
        }
        return values.get(LOCALE_BLANK);
    }

    private static void addRow(XSSFSheet s, int rn, String object, String property, String value) {
        XSSFRow r = s.createRow(rn);
        r.createCell(0).setCellValue(object);
        r.createCell(1).setCellValue(property);
        r.createCell(2).setCellValue(value);
    }
}

