/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.helpers;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.ibecorp.storage.XreportsBookingMarkerObject;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportGroup;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportReference;
import com.gridnine.xtrip.common.model.ibecorp.xreports.XreportsIntegrationSettings;
import com.gridnine.xtrip.common.model.standard.helpers.URLConnectionHelper;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.helpers.ShipmentRegistryHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.auth.XReportsApiKeyProvider;
import com.gridnine.xtrip.server.ibecorp.rest.reports.personalData.XReportsPersonalDataAllowanceKeyProvider;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.LoggerFactory;

public class XreportsIntegrationHelper {
    public static XreportsIntegrationSettings getSettings() {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(XreportsIntegrationSettings.class.getName());
        EntityContainer settings = EntityStorage.get().load(XreportsIntegrationSettings.class, settingsUid);
        if (settings == null) {
            settings = new EntityContainer(XreportsIntegrationSettings.class, settingsUid);
            ((XreportsIntegrationSettings)settings.getEntity()).setType(SystemSettingsType.OTHER);
            ((XreportsIntegrationSettings)settings.getEntity()).setName(MetaRegistryHelper.getDisplayName(XreportsIntegrationSettings.class));
            ((XreportsIntegrationSettings)settings.getEntity()).setSendPersonalData(false);
            ((XreportsIntegrationSettings)settings.getEntity()).setViewPersonalData(false);
            ((XreportsIntegrationSettings)settings.getEntity()).setPackSize(300);
            EntityStorage.get().save(settings, true);
        }
        return (XreportsIntegrationSettings)settings.getEntity();
    }

    public static boolean settingsExist() {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(XreportsIntegrationSettings.class.getName());
        return EntityStorage.get().load(XreportsIntegrationSettings.class, settingsUid) != null;
    }

    public static List<ReportGroup> getAllReportGroups() throws Exception {
        return XreportsIntegrationHelper.getResult(new GetRequestAdapter<List<ReportGroup>>(){

            @Override
            public String buildUrl(String basePath) {
                return String.format("%sallReports?showTuiReports=%b&locale=%s", basePath, AppConfiguration.get().isShowTuiReports(), LocaleHelper.getCurrentLocale().getLanguage());
            }

            @Override
            public List<ReportGroup> buildResult(JsonObject obj) {
                ArrayList<ReportGroup> result = new ArrayList<ReportGroup>();
                obj.getAsJsonArray("reportGroups").forEach(elm -> {
                    ReportGroup gr = new ReportGroup();
                    gr.setUid(elm.getAsJsonObject().get("id").getAsString());
                    gr.setTitle(elm.getAsJsonObject().get("caption").getAsString());
                    result.add(gr);
                    elm.getAsJsonObject().getAsJsonArray("reports").forEach(reportElm -> {
                        ReportReference item = new ReportReference();
                        item.setUid(reportElm.getAsJsonObject().get("id").getAsString());
                        item.setTitle(reportElm.getAsJsonObject().get("caption").getAsString());
                        gr.getReports().add(item);
                    });
                });
                return result;
            }

            @Override
            public List<ReportGroup> buildErrorResult() {
                return Collections.emptyList();
            }

            @Override
            public void handleException(Exception e) throws Exception {
                LoggerFactory.getLogger(XreportsIntegrationHelper.class).error("unable to get list of reports", (Throwable)e);
                throw e;
            }
        });
    }

    public static Map<String, String> getAllRegistryFields() throws Exception {
        return XreportsIntegrationHelper.getResult(new GetRequestAdapter<Map<String, String>>(){

            @Override
            public String buildUrl(String basePath) {
                return String.format("%sallRegistryFields?locale=%s", basePath, LocaleHelper.getCurrentLocale().getLanguage());
            }

            @Override
            public Map<String, String> buildResult(JsonObject obj) {
                TreeMap<String, String> result = new TreeMap<String, String>();
                obj.getAsJsonArray("uids").forEach(elm -> result.put(elm.getAsJsonObject().get("id").getAsString(), elm.getAsJsonObject().get("title").getAsString()));
                return result;
            }

            @Override
            public Map<String, String> buildErrorResult() {
                return Collections.emptyMap();
            }

            @Override
            public void handleException(Exception e) throws Exception {
                LoggerFactory.getLogger(XreportsIntegrationHelper.class).error("unable to get list of registry fields", (Throwable)e);
                throw e;
            }
        });
    }

    public static Boolean checkPersonalData() throws Exception {
        return XreportsIntegrationHelper.getResult(new GetRequestAdapter<Boolean>(){

            @Override
            public String buildUrl(String basePath) {
                return String.format("%scheckPersonalData", basePath);
            }

            @Override
            public Boolean buildResult(JsonObject obj) {
                return obj.getAsJsonObject().get("allowed").getAsBoolean();
            }

            @Override
            public Boolean buildErrorResult() {
                return Boolean.FALSE;
            }

            @Override
            public void handleException(Exception e) throws Exception {
                LoggerFactory.getLogger(XreportsIntegrationHelper.class).error("unable to check personal data use permission", (Throwable)e);
                throw e;
            }
        });
    }

    public static Integer getKettlePackSize() throws Exception {
        return XreportsIntegrationHelper.getKettlePackSize(null);
    }

    public static Integer getKettlePackSize(XreportsIntegrationSettings settings) throws Exception {
        return XreportsIntegrationHelper.getResult(new GetRequestAdapter<Integer>(){

            @Override
            public String buildUrl(String basePath) {
                return String.format("%sgetKettlePackSize", basePath);
            }

            @Override
            public Integer buildResult(JsonObject obj) {
                return obj.getAsJsonObject().get("size").getAsInt();
            }

            @Override
            public Integer buildErrorResult() {
                return 0;
            }

            @Override
            public void handleException(Exception e) throws Exception {
                LoggerFactory.getLogger(XreportsIntegrationHelper.class).error("unable to get kettle pack size", (Throwable)e);
                throw e;
            }
        }, settings);
    }

    public static boolean setKettlePackSize(int size) throws Exception {
        return XreportsIntegrationHelper.setKettlePackSize(size, null);
    }

    public static boolean setKettlePackSize(final int size, XreportsIntegrationSettings settings) throws Exception {
        return XreportsIntegrationHelper.getResult(new GetRequestAdapter<Boolean>(){

            @Override
            public String buildUrl(String basePath) {
                return String.format("%ssetKettlePackSize?size=%d", basePath, size);
            }

            @Override
            public Boolean buildResult(JsonObject obj) {
                return obj.getAsJsonObject().get("success").getAsBoolean();
            }

            @Override
            public Boolean buildErrorResult() {
                return false;
            }

            @Override
            public void handleException(Exception e) throws Exception {
                LoggerFactory.getLogger(XreportsIntegrationHelper.class).error("unable to set kettle pack size", (Throwable)e);
                throw e;
            }
        }, settings);
    }

    public static List<ReportReference> getAllRegistries() throws Exception {
        return XreportsIntegrationHelper.getResult(new GetRequestAdapter<List<ReportReference>>(){

            @Override
            public String buildUrl(String basePath) {
                return basePath + "allRegistries";
            }

            @Override
            public List<ReportReference> buildResult(JsonObject obj) {
                ArrayList<ReportReference> result = new ArrayList<ReportReference>();
                obj.getAsJsonArray("reports").forEach(elm -> {
                    ReportReference item = new ReportReference();
                    JsonObject reportElm = elm.getAsJsonObject();
                    item.setUid(reportElm.get("id").getAsString());
                    item.setTitle(reportElm.get("caption").getAsString());
                    result.add(item);
                });
                Collections.sort(result, Comparator.comparing(item -> item.getTitle() == null ? "???" : item.getTitle()));
                return result;
            }

            @Override
            public List<ReportReference> buildErrorResult() {
                return Collections.emptyList();
            }

            @Override
            public void handleException(Exception e) throws Exception {
                LoggerFactory.getLogger(XreportsIntegrationHelper.class).error("unable to get list of xreports", (Throwable)e);
                throw e;
            }
        });
    }

    public static boolean isSendPersonalDataAllowed() {
        boolean result;
        boolean bl = result = ((XReportsPersonalDataAllowanceKeyProvider)Environment.getPublished(XReportsPersonalDataAllowanceKeyProvider.class)).checkAllowance() != false && XreportsIntegrationHelper.getSettings().isSendPersonalData();
        if (result) {
            try {
                result = XreportsIntegrationHelper.checkPersonalData();
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isViewPersonalDataAllowed() {
        return ((XReportsPersonalDataAllowanceKeyProvider)Environment.getPublished(XReportsPersonalDataAllowanceKeyProvider.class)).checkAllowance() != false && XreportsIntegrationHelper.getSettings().isViewPersonalData();
    }

    public static boolean isPersonalDataStuffOff() {
        boolean result = ((XReportsPersonalDataAllowanceKeyProvider)Environment.getPublished(XReportsPersonalDataAllowanceKeyProvider.class)).checkAllowance();
        if (result) {
            try {
                result = XreportsIntegrationHelper.checkPersonalData();
            }
            catch (Exception e) {
                result = false;
            }
        }
        return !result;
    }

    public static int getOptimalKettlePackSize() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)XreportsBookingMarkerObject.Property.deleted.name(), (Object)Boolean.FALSE));
        List data = AssetsStorage.get().search(XreportsBookingMarkerObject.class, query).getData();
        if (data.size() < 1000) {
            return 1000;
        }
        if (data.size() < 5000) {
            return data.size() / 4;
        }
        if (data.size() < 20000) {
            return data.size() / 5;
        }
        return 4000;
    }

    public static boolean deleteMarkerObjects() {
        return XreportsIntegrationHelper.getSettings().isDeleteMarkerObjects();
    }

    public static List<String> getEmails() {
        return XreportsIntegrationHelper.getSettings().getEmails();
    }

    public static String getLink(String login) throws Exception {
        XreportsIntegrationSettings settings = XreportsIntegrationHelper.getSettings();
        if (settings != null && settings.isEnabled() && TextUtil.nonBlank((String)settings.getServerAddress()) && AclHelper.isGranted(null, (String)IbeRestrictionEntityResources.ENTITY_REPORT_APPLICATION.getId(), (String)login, (String)StandardAclResourceOperations.ALL.getId(), Collections.emptyList())) {
            return settings.getServerAddress().startsWith("http://") || settings.getServerAddress().startsWith("https://") ? settings.getServerAddress() : String.format("http://%s", settings.getServerAddress());
        }
        return null;
    }

    private static <R> R getResult(GetRequestAdapter<R> adapter) throws Exception {
        return XreportsIntegrationHelper.getResult(adapter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <R> R getResult(GetRequestAdapter<R> adapter, XreportsIntegrationSettings iSettings) throws Exception {
        XreportsIntegrationSettings settings;
        XreportsIntegrationSettings xreportsIntegrationSettings = settings = iSettings == null ? XreportsIntegrationHelper.getSettings() : iSettings;
        if (!settings.isEnabled()) {
            return adapter.buildErrorResult();
        }
        if (TextUtil.isBlank((String)settings.getServerAddress())) {
            IncidentsLog.reportAdminStackTrace((String)"Reports server address is empty");
            return adapter.buildErrorResult();
        }
        String url = adapter.buildUrl(String.format("%s/rest/mom/", settings.getServerAddress().startsWith("http://") || settings.getServerAddress().startsWith("https://") ? settings.getServerAddress() : String.format("http://%s", settings.getServerAddress())));
        try {
            URLConnection connection = URLConnectionHelper.prepareURLConnection((URL)new URL(url), null);
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setUseCaches(false);
            ((HttpURLConnection)connection).setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "text/html; charset=utf-8");
            String apiKey = ((XReportsApiKeyProvider)Environment.getPublished(XReportsApiKeyProvider.class)).getApiKey();
            if (apiKey == null) {
                throw new Exception("Api key to access reports application wasn't found");
            }
            connection.setRequestProperty("MOM_AUTH", apiKey);
            connection.setRequestProperty("REPORTS_LOGIN", UserData.get().getCurrentUser());
            try (InputStream is = connection.getInputStream();){
                JsonObject obj = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(is, "utf-8"));
                R r = adapter.buildResult(obj.getAsJsonObject("result"));
                return r;
            }
        }
        catch (Exception e) {
            adapter.handleException(e);
            return adapter.buildErrorResult();
        }
    }

    public static ExportedReport getShipmentRegistry(final String reportUid, final Shipment shipment) throws Exception {
        return XreportsIntegrationHelper.getResult(new GetRequestAdapter<ExportedReport>(){

            @Override
            public String buildUrl(String basePath) {
                return String.format("%sshipmentRegistry?registryUid=%s&shipmentNumber=%s", basePath, reportUid, shipment.getNumber());
            }

            @Override
            public ExportedReport buildResult(JsonObject obj) throws Exception {
                ExportedReport result = new ExportedReport();
                result.setFileName(obj.get("fileName").getAsString());
                byte[] originalExcel = Base64.decode((String)obj.get("content").getAsString());
                result.setContent(ShipmentRegistryHelper.addMidofficeDataToExcel(originalExcel, shipment));
                return result;
            }

            @Override
            public ExportedReport buildErrorResult() {
                return null;
            }

            @Override
            public void handleException(Exception e) throws Exception {
                LoggerFactory.getLogger(XreportsIntegrationHelper.class).error("unable to get report", (Throwable)e);
                throw e;
            }
        });
    }

    public static class ExportedReport {
        private String fileName;
        private byte[] content;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }
    }

    static interface GetRequestAdapter<R> {
        public String buildUrl(String var1);

        public R buildResult(JsonObject var1) throws Exception;

        public R buildErrorResult();

        public void handleException(Exception var1) throws Exception;
    }
}

