/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.IbeSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class GetIbeSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IbeSettings settings;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)IbeSettings.class.getName()));
        List data = EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData();
        switch (data.size()) {
            case 1: {
                settings = (IbeSettings)EntityStorage.get().resolve(((BasicSystemSettingsIndex)data.get(0)).getSource()).getEntity();
                break;
            }
            case 0: {
                settings = this.firstTimeLoad();
                EntityContainer ctr = EntityContainer.create((BaseEntity)settings);
                EntityStorage.get().save(ctr, true);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"{0} ibe settings found", (Object[])new Object[]{data.size()});
            }
        }
        ctx.putObject((Enum)IBusIbecorpContextKeys.IBE_SETTINGS, (Object)settings);
    }

    private IbeSettings firstTimeLoad() throws Exception {
        IbeSettings settings = new IbeSettings();
        settings.setName("IBE settings");
        settings.setType(SystemSettingsType.OTHER);
        settings.setSirenaFilter("AA,AB,AF,AM,AT,AY,AZ,A3,A9,BA,BD,BI,BT,B2,CA,CI,CM,CX,CY,CZ,DE,DL,EK,ET,EY,FB,FI,FJ,FV,F7,GA,HM,HR,HU,HX,HY,IB,IG,IY,IZ,JJ,JL,JP,JU,J2,KC,KE,KL,KM,LA,LH,LO,LX,LY,MD,MK,MS,MU,NX,NZ,OA,OK,OM,OS,OU,OV,OY,PG,PS,QR,RC,RJ,SA,SK,SN,SQ,SU,SW,S3,S4,S7,TG,TK,TN,TP,TU,TX,UA,UL,UN,UX,U9,VN,VS,VV,WY,YM,YO,ZI,2U,5L,5N,6H,7D,9U,9W");
        return settings;
    }
}

