/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.CollectedContractData;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractorDescriptionIndex;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class IbeCorpFlightCommissionsCalculatorAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SalesContext sc1 = (SalesContext)XCloneHelper.clone((XCloneable)sc, (boolean)true);
        sc1.setAgency(sc1.getSubagency());
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)sc1);
        ctx.putObject((Enum)IBusIbecorpContextKeys.COPY_OF_SALES_CONTEXT, (Object)sc);
        Map contractsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP);
        HashMap<Flight, XCloneable> salesChainMap = new HashMap<Flight, XCloneable>();
        for (Flight flight : contractsMap.keySet()) {
            salesChainMap.put(flight, XCloneHelper.clone((XCloneable)flight.getSalesChain()));
            EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
            EntityReference technicalProvider = GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER);
            EntityReference subagency = GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY);
            EntityReference client = GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.CLIENT);
            SalesChain ownSalesChain = new SalesChain();
            if (technicalProvider != null) {
                ownSalesChain.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)PredefinedSalesChainType.OWN_TECHNICAL_PROVIDER, null));
            } else {
                ownSalesChain.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)PredefinedSalesChainType.OWN, null));
            }
            GeneralProductHelper.setContractor((SalesChain)ownSalesChain, (PredefinedContractorType)PredefinedContractorType.SUPPLIER, (EntityReference)supplier);
            GeneralProductHelper.setContractor((SalesChain)ownSalesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY, (EntityReference)subagency);
            GeneralProductHelper.setContractor((SalesChain)ownSalesChain, (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, (EntityReference)subagency);
            GeneralProductHelper.setContractor((SalesChain)ownSalesChain, (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, (EntityReference)technicalProvider);
            Contractor result = new Contractor();
            EntityContainer ctr = EntityStorage.get().find(ContractorDescriptionIndex.class, ContractorDescriptionIndex.Property.predefinedType.name(), (Object)PredefinedContractorType.CLIENT);
            result.setDescription(ctr == null ? null : ctr.toReference());
            result.setContractor(client);
            ownSalesChain.getContractors().add(result);
            flight.setSalesChain(ownSalesChain);
        }
        ctx.putObject((Enum)IBusIbecorpContextKeys.FLIHT_TO_ORIGINAL_SALESCHAIN_MAP, salesChainMap);
        ctx.putObject((Enum)IBusIbecorpContextKeys.COPY_OF_CONTRACTS_MAP, (Object)contractsMap);
    }

    public void after(MessageContext ctx) throws Exception {
        LinkedHashMap result = new LinkedHashMap();
        Map modifiedResult = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP);
        Map standardResult = (Map)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.COPY_OF_CONTRACTS_MAP);
        Map salesChainMap = (Map)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.FLIHT_TO_ORIGINAL_SALESCHAIN_MAP);
        for (Map.Entry flightEntry : standardResult.entrySet()) {
            Map.Entry entry;
            Flight flight = (Flight)flightEntry.getKey();
            Map modifiedContracts = (Map)modifiedResult.get(flight);
            boolean hasDirectVendorContracts = false;
            if (modifiedContracts != null && !modifiedContracts.isEmpty() && GeneralProductHelper.getContractType((EntityReference)((EntityReference)(entry = modifiedContracts.entrySet().iterator().next()).getKey())) == ContractType.VENDOR && !((CollectedContractData)entry.getValue()).getContractContainers().isEmpty()) {
                hasDirectVendorContracts = true;
            }
            if (hasDirectVendorContracts) {
                flight.setHasDirectVendorContracts(true);
                result.put(flight, modifiedContracts);
                continue;
            }
            result.put(flight, flightEntry.getValue());
            flight.setSalesChain((SalesChain)salesChainMap.get(flight));
        }
        ctx.putObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP, result);
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.COPY_OF_SALES_CONTEXT));
    }
}

