/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class IbeCorpRecoverBookingProductsStatusHandler
extends BaseProcessor {
    private ProductStatus status;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.status = ProductStatus.valueOf((String)parameters.get("status"));
    }

    public void process(MessageContext ctx) {
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        reservation.getProducts().stream().filter(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.BOOKING).forEach(p -> GeneralProductHelper.getHandler((BaseProduct)p).setStatus(p, this.status));
        callback.exceptionHandled(true);
        Throwable exception = callback.getException();
        String message = exception instanceof Xeption ? ((Xeption)exception).toMessageString() : exception.getMessage();
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)message, (Object[])new Object[0]));
    }
}

