/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public class IbeCorpSalesContextAgentCompanyValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        this.checkAgentCompany(salesContext);
    }

    private void checkAgentCompany(SalesContext salesContext) {
        EntityReference agentReference = salesContext.getAgent();
        if (agentReference == null) {
            return;
        }
        EntityContainer agentContainer = EntityStorage.get().resolve(agentReference);
        if (agentContainer == null) {
            return;
        }
        HashSet<String> salesContextCompanyUids = new HashSet<String>();
        salesContextCompanyUids.add(salesContext.getSubagency().getUid());
        if (!ProfileHelper.isRetailProfile((EntityReference)salesContext.getClient())) {
            salesContextCompanyUids.add(salesContext.getClient().getUid());
        }
        boolean employmentOk = false;
        for (PersonEmployment pe : ((Person)agentContainer.getEntity()).getEmployments()) {
            if (!MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)new Date()) || !this.isCorrectEmployer((EntityReference<Organization>)pe.getOrganization(), salesContextCompanyUids)) continue;
            employmentOk = true;
            break;
        }
        if (!employmentOk) {
            throw Xeption.forAdmin((String)"\u0410\u0433\u0435\u043d\u0442 '{0}' \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043f\u0440\u043e\u0434\u0430\u0436.", (Object[])new Object[]{agentReference});
        }
    }

    private boolean isCorrectEmployer(EntityReference<Organization> employer, Collection<String> salesContextCompanyUids) {
        if (employer == null) {
            return false;
        }
        if (salesContextCompanyUids.contains(employer.getUid())) {
            return true;
        }
        return CorporateClientHelper.getCorporateClients(employer).stream().map(EntityReference::getUid).anyMatch(salesContextCompanyUids::contains);
    }
}

