/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;

public class IbeCorpSalesContextSalesPointValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        this.checkSalesPoint(ctx, salesContext);
    }

    private void checkSalesPoint(MessageContext ctx, SalesContext salesContext) {
        EntityContainer siteCtr;
        EntityReference siteRef = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.SITE);
        if (Objects.isNull(siteRef)) {
            siteRef = salesContext.getSite();
        }
        if (Objects.nonNull(siteRef) && ((SMSite)(siteCtr = EntityStorage.get().resolve(siteRef)).getEntity()).getSiteType() == SMSiteType.B2B) {
            return;
        }
        EntityReference salesPointReference = salesContext.getSalesPoint();
        if (Objects.nonNull(salesPointReference)) {
            EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
            if (salesPointContainer == null) {
                throw Xeption.forDeveloper((String)"sales point '{0}' from sales context was not resolved", (Object[])new Object[]{salesPointReference});
            }
            SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
            if (!MiscUtil.equals((Object)salesContext.getSubagency(), (Object)salesPoint.getAgency())) {
                throw Xeption.forAdmin((String)"\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436 '{0}' \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0443 '{1}'.", (Object[])new Object[]{salesPointReference, salesContext.getSubagency()});
            }
        }
    }
}

