/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.SalesContextValidator;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.Optional;
import java.util.Set;

public class IbeCorpSalesContextValidator
extends SalesContextValidator {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        super.process(ctx);
        this.checkSite(ctx, salesContext);
    }

    private void checkSite(MessageContext ctx, SalesContext salesContext) {
        EntityReference siteRef = salesContext.getSite();
        if (siteRef == null) {
            throw Xeption.forDeveloper((String)"missing site in sales context", (Object[])new Object[0]);
        }
        EntityContainer siteCtr = EntityStorage.get().resolve(siteRef);
        if (siteCtr == null) {
            throw Xeption.forDeveloper((String)"site from sales context was not resolved", (Object[])new Object[0]);
        }
    }

    protected void checkAgent(MessageContext ctx, SalesContext salesContext) throws Exception {
        EntityReference agentReference = salesContext.getAgent();
        if (agentReference == null) {
            throw Xeption.forDeveloper((String)"missing agent in sales context", (Object[])new Object[0]);
        }
        EntityContainer agentContainer = EntityStorage.get().resolve(agentReference);
        if (agentContainer == null) {
            throw Xeption.forDeveloper((String)"agent '{0}' from sales context was not resolved", (Object[])new Object[]{agentReference});
        }
        Person agent = (Person)agentContainer.getEntity();
        if (!agent.getTypes().contains(PersonType.AGENT) && !agent.getTypes().contains(PersonType.WEB_AGENT)) {
            if (agent.getTypes().contains(PersonType.PASSENGER)) {
                EntityReference client = salesContext.getClient();
                EntityReference<Organization> agentEmployer = this.findMainEmploymentForPerson((EntityReference<Person>)agentReference);
                if (agentEmployer == null) {
                    throw Xeption.forAdmin((String)"\u041a\u043e\u0440\u043f\u043e\u0440\u0430\u043d\u0442 '{0}' \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b", (Object[])new Object[]{agentReference});
                }
                if (!agentEmployer.equals((Object)client) && !CorporateClientHelper.getCorporateClients(agentEmployer).contains(client)) {
                    throw Xeption.forAdmin((String)"\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u043d\u0442\u0430 '{0}' : '{1}' \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c \u0432 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435 '{2}' \u0438 \u043d\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043e \u0441 \u043d\u0438\u043c.", (Object[])new Object[]{agentReference, agentEmployer, client});
                }
                return;
            }
            throw Xeption.forAdmin((String)"\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e '{0}' \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u043e\u043b\u0438 '{1}' \u0438\u043b\u0438 '{2}'.", (Object[])new Object[]{agentReference, PersonType.AGENT, PersonType.WEB_AGENT});
        }
    }

    private EntityReference<Organization> findMainEmploymentForPerson(EntityReference<Person> personRef) {
        Date currentDate = new Date();
        for (PersonEmployment item : ((Person)EntityStorage.get().resolve(personRef).getEntity()).getEmployments()) {
            if (!item.isMainEmployment() || item.getOpened() != null && item.getOpened().after(currentDate) || item.getClosed() != null && item.getClosed().before(currentDate)) continue;
            return item.getOrganization();
        }
        return null;
    }

    protected void checkClientAssociation(EntityReference<Organization> subagencyReference, EntityContainer<Organization> clientContainer) {
        Set<EntityReference<Organization>> corporateClients;
        Optional<EntityReference> client;
        if (((Organization)clientContainer.getEntity()).getParent() == null ? !(client = (corporateClients = CorporateClientHelper.getCorporateClients(subagencyReference)).stream().filter(cl -> cl.equals((Object)clientContainer.toReference())).findFirst()).isPresent() : !MiscUtil.equals(subagencyReference, (Object)((Organization)clientContainer.getEntity()).getParent()) && !CommonIbecorpHelper.isContractPresent(subagencyReference, (EntityReference)clientContainer.toReference(), (ContractType)ContractType.CLIENT)) {
            throw Xeption.forAdmin((String)"\u041a\u043b\u0438\u0435\u043d\u0442 '{0}' \u043d\u0435 \u0430\u0441\u0441\u043e\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u043e\u043c '{1}'.", (Object[])new Object[]{clientContainer.toReference(), subagencyReference});
        }
    }
}

