/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingDocumentAdvice;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.trace.GdsTracingHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.minimalPrice.MinimalPriceSearchTarget;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class IbeGdsTracingAdvice
extends GdsTracingDocumentAdvice {
    protected GdsTracingDocument createTracingDocumentIfNeeded(MessageContext ctx) {
        SalesContext salesContext = (SalesContext)ctx.getObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        String login = null;
        if (salesContext != null) {
            EntityContainer loggedPersonCtr = EntityStorage.get().resolve(salesContext.getCustomer());
            if (loggedPersonCtr == null) {
                loggedPersonCtr = EntityStorage.get().resolve(salesContext.getAgent());
            }
            if (loggedPersonCtr != null) {
                login = ((Person)loggedPersonCtr.getEntity()).getLoginName();
            }
        } else {
            login = UserData.get().getCurrentUser();
        }
        if (login != null) {
            String compoundKey = GdsTracingHelper.getCompoundKey((String)login);
            EntityContainer ctr = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)compoundKey);
            if (ctr == null) {
                return null;
            }
            GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctr.getEntity();
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS, (Object)gdsTracingSettings);
            if (gdsTracingSettings.isActive() && (gdsTracingSettings.isSaveSearchTraces() || gdsTracingSettings.isSaveRulesTraces())) {
                GdsTracingDocument document = new GdsTracingDocument();
                document.setName(this.buildDocumentName(ctx));
                document.setSettings(ctr.toReference());
                document.setCreated(new Date());
                return document;
            }
        }
        return null;
    }

    protected String buildDocumentName(MessageContext ctx) {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        String documentName = gdsAccountCtr == null ? this.docName : String.format("%s-%s", this.docName, ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName());
        MinimalPriceSearchTarget target = (MinimalPriceSearchTarget)((Object)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_MINIMAL_PRICE_SEARCH_TARGET));
        if (target != null) {
            documentName = String.format("%s-%s", target.name(), documentName);
        }
        return documentName;
    }
}

