/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutPaymentTypeProcessorIBE
extends BaseProcessor {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String CONTEXT_KEY;
    private PaymentType paymentType = null;

    public void configure(Map<String, String> parameters) {
        this.CONTEXT_KEY = this.getKey(parameters, "context-key", (Enum<?>)IBusGdsContextKeys.PAYMENT_TYPE);
        this.paymentType = PaymentType.valueOf((String)parameters.get("payment-type"));
    }

    private String getKey(Map<String, String> parameters, String key, Enum<?> defaultValue) {
        return parameters.containsKey(key) ? parameters.get(key) : defaultValue.name();
    }

    public void process(MessageContext context) throws Exception {
        try {
            EntityReference site = null;
            try {
                site = (EntityReference)context.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
            }
            catch (Exception eInternal) {
                SalesContext salesContext = (SalesContext)context.getMandatoryObject("SALES_CONTEXT");
                site = salesContext.getSite();
            }
            SMGeneralSettings settings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)site);
            PaymentType defaultPaymentType = settings.getDefaultPaymentType();
            if (defaultPaymentType != null) {
                context.putObject(this.CONTEXT_KEY, (Object)defaultPaymentType);
            } else {
                context.putObject(this.CONTEXT_KEY, (Object)this.paymentType);
            }
        }
        catch (Exception e) {
            context.putObject(this.CONTEXT_KEY, (Object)this.paymentType);
            this.log.warn("Can't set defaultPaymentType from site settings.", (Throwable)e);
        }
    }
}

