/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.endTransaction.EndTransactionRQParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class SabreTicketingEndTransactionsRQParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EndTransactionRQParameters parameters = new EndTransactionRQParameters();
        if (Boolean.TRUE.equals(ctx.getObject((Enum)IBusGdsSabreContextKeys.TICKETING_COMPLETE))) {
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            SMNotificationsSettings settings = this.getSMNotificationsSettings(salesContext);
            parameters.setEmail(!settings.isSabreTraveldocSkipMail());
            parameters.setN00(settings.isSabreTraveldocInline());
            parameters.setPdf(settings.isSabreTraveldocPdf());
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.END_TRANSACTION_RQ_PARAMETERS, (Object)parameters);
    }

    private SMNotificationsSettings getSMNotificationsSettings(SalesContext salesContext) throws Exception {
        EntityReference profile = ProfileHelper.getProfile((EntityReference)salesContext.getSite(), (SMProfileType)SMProfileType.NOTIFICATIONS_SETTINGS);
        if (profile == null) {
            throw new Exception(String.format("no settings of type %s found for subagency %s", SMProfileType.NOTIFICATIONS_SETTINGS, salesContext.getSubagency()));
        }
        return (SMNotificationsSettings)EntityStorage.get().resolve(profile).getEntity();
    }
}

