/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class SendReservationCancelledNotificationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection reservations = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        BookingFile bookingFile = (BookingFile)bfCtr.getEntity();
        for (Reservation reservation : NotificationHelper.getReservations((EntityContainer<BookingFile>)bfCtr, reservations)) {
            if (CommonIbecorpHelper.getReservationStatus((Reservation)reservation) != ReservationStatus.CANCELED) continue;
            EntityReference bookingRef = bfCtr.toReference();
            NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)bookingFile.getCustomerProfile(), (EntityReference<SMSite>)bookingFile.getSite(), bookingFile.getCustomer().getPreferredLocale(), bookingRef, salesContext);
            NotificationHelper.sendNotification(() -> NotificationHelper.getCancelReservationNotification(parameters, reservation), bookingRef, true);
        }
    }
}

