/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.actualizeSegments;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;

public class SirenaUpdateSegmentsProcessor
extends BaseProcessor {
    private final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.CRT.name(), CodeSystem.IATA.name()});

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        SegmentTariff segmentTariff = new SegmentTariff();
        int idx = 1;
        for (Pnr.Segments.Segment elm : answer.getPnr().getSegments().getSegments()) {
            Segment seg = new Segment();
            String id = elm.getId();
            seg.setRecordNumber(idx++);
            seg.setAirline(this.codeTranslator.resolveNativeCode(Airline.class, elm.getCompany()));
            seg.setFlightNo(elm.getFlight());
            SimpleDateFormat dtf = new SimpleDateFormat("dd.MM.yy HH:mm");
            seg.setDepartureLocation(this.codeTranslator.resolveNativeCode(GeoLocation.class, SirenaUpdateSegmentsProcessor.getLocation(elm.getDeparture())));
            seg.setArriveLocation(this.codeTranslator.resolveNativeCode(GeoLocation.class, SirenaUpdateSegmentsProcessor.getLocation(elm.getArrival())));
            try {
                seg.setStartDate(dtf.parse(elm.getDeparture().getDate() + ' ' + elm.getDeparture().getTime()));
            }
            catch (Exception e) {
                this.log.warn("failed parsing departure date-time", (Throwable)e);
            }
            try {
                seg.setEndDate(dtf.parse(elm.getArrival().getDate() + ' ' + elm.getArrival().getTime()));
            }
            catch (Exception e) {
                this.log.warn("failed parsing arrival date-time", (Throwable)e);
            }
            seg.setStatus(elm.getStatus().getText());
            seg.setBoard(this.codeTranslator.resolveNativeCode(Aircraft.class, elm.getAirplane()));
            seg.setGdsId(id);
            segmentTariff.getSegments().add(seg);
        }
        for (BaseProduct bp : reservation.getProducts()) {
            Product product = (Product)bp;
            product.getSegmentTariffs().clear();
            product.getSegmentTariffs().add(segmentTariff);
        }
    }

    private static String getLocation(Pnr.Segments.Segment.Location elm) {
        if (elm == null) {
            return null;
        }
        String result = elm.getAirport();
        return TextUtil.isBlank((String)result) ? elm.getCity() : result;
    }
}

