/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.airline.FindRulesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.EntityOperationTracingPartBuilder;

public class OrganizationAirlineGetRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces() && builder != null;
        RuleSet ruleSet = FindRulesHelper.getRuleSet((EntityReference<Organization>)salesContext.getSubagency());
        EntityOperationTracingPartBuilder builder2 = (EntityOperationTracingPartBuilder)ctx.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_PART_BUILDER);
        if (ruleSet != null && !ruleSet.isEmpty()) {
            if (isSaveRulesTraces) {
                builder.traceGlobalLogic(String.format("using airlines settings for subagency %s", salesContext.getSubagency()));
            }
            if (builder2 != null) {
                builder2.traceLogic(String.format("using airlines settings for subagency %s", salesContext.getSubagency()));
            }
            ctx.putObject((Enum)IBusGdsContextKeys.RULES, (Object)ruleSet);
            return;
        }
        EntityReference<Organization> mainAgency = CommonHelper.findMainAgency();
        ruleSet = FindRulesHelper.getRuleSet(mainAgency);
        if (ruleSet != null) {
            if (isSaveRulesTraces) {
                builder.traceGlobalLogic(String.format("using airlines settings for main agency %s", mainAgency));
            }
            if (builder2 != null) {
                builder2.traceLogic(String.format("using airlines settings for main agency %s", mainAgency));
            }
            ctx.putObject((Enum)IBusGdsContextKeys.RULES, (Object)ruleSet);
            return;
        }
        if (isSaveRulesTraces) {
            builder.traceGlobalLogic("using empty rule set");
        }
        if (builder2 != null) {
            builder2.traceLogic("using empty rule set");
        }
        ctx.putObject((Enum)IBusGdsContextKeys.RULES, (Object)new RuleSet());
    }
}

