/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class AlfastrahCreateFopsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        InsuranceTouristic product = (InsuranceTouristic)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.PRODUCT);
        for (GeneralProductContractRelationData item : InsuranceTouristicHelper.getContractRelations((InsuranceTouristic)product)) {
            item.getFops().clear();
            HotelProductFop fop = new HotelProductFop();
            fop.setType(PaymentType.INVOICE);
            fop.setEquivalentAmount(product.getEquivalentSum());
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case SUBAGENCY: {
                    if (!this.haveSubagency(product)) break;
                }
                case VENDOR: 
                case CLIENT: {
                    item.getFops().add(fop);
                }
            }
        }
    }

    private boolean haveSubagency(InsuranceTouristic product) {
        EntityReference agency = InsuranceTouristicHelper.getAgency((InsuranceTouristic)product);
        EntityReference subagency = InsuranceTouristicHelper.getSubagency((InsuranceTouristic)product);
        return agency != null && subagency != null && !agency.equals((Object)subagency);
    }
}

