/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import ru.alfastrah.ti.insurancealfaservice.Insured;
import ru.alfastrah.ti.insurancealfaservice.Policy;

public class AlfastrahCreateTravellersProcessor
extends BaseProcessor {
    private static final Pattern PASSPORT_PATTERN = Pattern.compile("(\\d*),(.*),(.*),((\\d{2}\\.\\d{2}\\.\\d{4})?)");

    public void process(MessageContext ctx) throws Exception {
        Policy policy = (Policy)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.POLICY);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.BOOKING_FILE);
        InsuranceTouristic product = (InsuranceTouristic)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.PRODUCT);
        product.getTravellersUids().clear();
        if (policy.getInsureds() == null || policy.getInsureds().getInsuredList() == null) {
            return;
        }
        for (Insured insured : policy.getInsureds().getInsuredList()) {
            Traveller traveller = new Traveller();
            Passport passport = new Passport();
            if (TextUtil.nonBlank((String)insured.getFio())) {
                traveller.setName(insured.getFio().trim());
                String[] splitName = insured.getFio().trim().split("\\s+");
                if (splitName.length > 0) {
                    passport.setLastName(splitName[0]);
                    if (splitName.length > 1) {
                        passport.setFirstName(splitName[1]);
                        if (splitName.length == 3) {
                            passport.setMiddleName(splitName[2]);
                        } else if (splitName.length > 3) {
                            passport.setSecondName(splitName[2]);
                            passport.setMiddleName(splitName[3]);
                        }
                    }
                }
            }
            traveller.setBirthday(MiscUtil.toDateWithoutTimeZone((DateTime)insured.getDateOfBirth()));
            passport.setBirthday(MiscUtil.toDateWithoutTimeZone((DateTime)insured.getDateOfBirth()));
            if (TextUtil.nonBlank((String)insured.getPassport())) {
                Matcher passportMatcher = PASSPORT_PATTERN.matcher(insured.getPassport());
                if (passportMatcher.matches()) {
                    String issueDate;
                    if ("22".equals(passportMatcher.group(1))) {
                        passport.setType(PassportType.FOREIGN);
                        passport.setCitizenship((DictionaryReference)DictHelper.getRuRef());
                    }
                    String series = passportMatcher.group(2);
                    String number = passportMatcher.group(3);
                    if (TextUtil.nonBlank((String)series) || TextUtil.nonBlank((String)number)) {
                        passport.setNumber((series + number).replaceAll("\\s+", ""));
                    }
                    if (TextUtil.nonBlank((String)(issueDate = passportMatcher.group(4)))) {
                        passport.setIssued(new SimpleDateFormat("dd.MM.yyyy").parse(issueDate));
                    }
                } else {
                    passport.setNumber(insured.getPassport().replaceAll("\\s+", ""));
                }
            }
            traveller.setPassport(passport);
            ((BookingFile)bookingFile.getEntity()).getTravellers().add(traveller);
            product.getTravellersUids().add(traveller.getUid());
        }
    }
}

