/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.model.AlfastrahSettings;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.AlfastrahAction;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.AlfastrahHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.ZonedDateTime;
import ru.alfastrah.ti.insurancealfaservice.GetPoliciesByBeginDate;
import ru.alfastrah.ti.insurancealfaservice.GetPoliciesParameters;

public class AlfastrahGetPoliciesByBeginDateRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AlfastrahSettings settings = (AlfastrahSettings)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.ALFASTRAH_SETTINGS);
        ZonedDateTime dateFrom = (ZonedDateTime)ctx.getMandatoryObject((Enum)IbusAlfastrahContextKeys.DATE_FROM);
        GetPoliciesParameters parameters = new GetPoliciesParameters();
        parameters.setUserId(settings.getUserId());
        parameters.setUserLogin(settings.getLogin());
        parameters.setUserPSW(settings.getPassword());
        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)settings.getPassword());
        parameters.setPolicyPeriodFrom(AlfastrahHelper.toDateTime(dateFrom));
        parameters.setPolicyPeriodTill(AlfastrahHelper.toDateTime(dateFrom.plusYears(1L)));
        GetPoliciesByBeginDate request = new GetPoliciesByBeginDate();
        request.setParameters(parameters);
        ctx.putObject((Enum)IbusAlfastrahContextKeys.REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusAlfastrahContextKeys.ALFASTRAH_ACTION, (Object)AlfastrahAction.GET_POLICIES_BY_BEGIN_DATE);
    }
}

