/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.alfastrah;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.AlfastrahSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.alfastrah.IbusAlfastrahContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;

public class AlfastrahLoadSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(AlfastrahSettings.class.getName());
        EntityContainer settings = EntityStorage.get().load(AlfastrahSettings.class, settingsUid);
        Objects.requireNonNull(settings, "Alfastrah settings are not found");
        TextUtil.requireNonBlank((String)((AlfastrahSettings)settings.getEntity()).getUrl(), (String)"URL is absent");
        TextUtil.requireNonBlank((String)((AlfastrahSettings)settings.getEntity()).getUserId(), (String)"User ID is absent");
        TextUtil.requireNonBlank((String)((AlfastrahSettings)settings.getEntity()).getLogin(), (String)"Login is absent");
        TextUtil.requireNonBlank((String)((AlfastrahSettings)settings.getEntity()).getPassword(), (String)"Password is absent");
        ctx.putObject((Enum)IbusAlfastrahContextKeys.ALFASTRAH_SETTINGS, (Object)settings.getEntity());
    }
}

